package com.elitescloud.cloudt.ucenter.api.vo.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Set;

@Data
@ApiModel(description = "网站栏目查询入参")
public class WebsiteBarPagingParam extends AbstractOrderQueryParam {

    @ApiModelProperty(value = "网站栏目配置id")
    private Long id;

    @ApiModelProperty(value = "适用商城", required = true)
    private String mallMode;

    @ApiModelProperty(value = "名称", required = true)
    private String barName;

    @ApiModelProperty(value = "栏位类型", required = true)
    private String barType;

    @ApiModelProperty(value = "链接类型", required = true)
    private String linkType;

    @ApiModelProperty(value = "打开方式", required = true)
    private String windowOpenMode;

    @ApiModelProperty(value = "是否为首页", required = true)
    private Boolean homePageFlag;

    @ApiModelProperty(value = "是否显示", required = true)
    private Boolean showFlag;

    private Set<Long> pidSet;

    @ApiModelProperty(value = "上级栏目", required = true)
    private String pName;

}
