package com.elitescloud.cloudt.ucenter.api.vo.resp;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel(description = "广告管理查询出参")
public class AdSpaceRespVO implements Serializable {
    private static final long serialVersionUID = 4406789299601680378L;

    @ApiModelProperty("广告位id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "广告位编码")
    private String adSpaceCode;

    @ApiModelProperty("广告位名称")
    private String adSpaceName;

    @ApiModelProperty(value = "广告位说明")
    private String adSpaceDesc;

    @ApiModelProperty(value = "排序")
    private Integer sortNo;

    @ApiModelProperty(value = "展示形式(wheel轮播/flat平铺/pop弹窗)")
    @SysCode(sys =  Application.NAME, mod = "SHOW_STYLE")
    private String showStyle;

    @ApiModelProperty(value = "展示形式名称")
    private String showStyleName;
}
