package com.elitescloud.cloudt.ucenter.api.vo.save;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@ApiModel(description = "广告新增编辑入参")
public class AdInfoSaveVO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 632396646377721743L;

//    @ApiModelProperty(value = "广告id")
//    private Long adId;

    @ApiModelProperty(value = "广告code")
    private String adCode;

    @ApiModelProperty(value = "广告标题")
    @NotBlank(message = "广告标题不能为空")
    private String adTitle;

    @ApiModelProperty(value = "广告位")
    private String adSpaceName;

    @ApiModelProperty(value = "广告位编码")
    @NotBlank(message = "广告位编码不能为空")
    private String adSpaceCode;

    @ApiModelProperty(value = "链接类型 INTERNAL-内部链接  EXTERNAL-外部链接  CUSTOM-自定义")
    @NotBlank(message = "链接类型不能为空")
    private String adLinkType;

    @ApiModelProperty(value = "排序")
    private Integer sortNo;

    @ApiModelProperty(value = "是否显示 HIDE-隐藏 DISPLAY-显示")
    @NotBlank(message = "是否显示不能为空")
    private String showFlag;

    @ApiModelProperty(value = "广告显示开始时间")
    @NotNull(message = "显示开始时间不能为空")
    private LocalDateTime showBeginTime;

    @ApiModelProperty(value = "广告显示结束时间")
    @NotNull(message = "显示结束时间不能为空")
    private LocalDateTime showEndTime;

    @ApiModelProperty(value = "资源类型")
    @NotBlank(message = "资源类型不能为空 1-图片 2-视频")
    private String sourceType;

    @ApiModelProperty(value = "目标类型")
    @NotBlank(message = "目标类型不能为空")
    private String targetType;

    @ApiModelProperty(value = "链接地址")
    private String linkAddress;

    @ApiModelProperty(value = "链接地址id")
    private Long linkAddressId;

    @ApiModelProperty(value = "广告图片/广告视频封面图片文件编码")
    private String imgFileCode;

    @ApiModelProperty(value = "视频文件编码")
    private String videoFileCode;

    @ApiModelProperty(value = "链接来源")
    private String linkSource;

//    @ApiModelProperty(value = "文件信息")
//    private List<FileInfo> fileInfoList;

//    class FileInfo{
//
//        @ApiModelProperty(value = "文件编码")
//        private String fileCode;
//
//        @ApiModelProperty(value = "文件原名称")
//        private String originalName;
//
//        @ApiModelProperty(value = "文件大小，字节B")
//        private Long fileSize;
//
//        @ApiModelProperty(value = "文件名后缀")
//        private String suffix;
//
//        @ApiModelProperty(value = "文件内容类型，mime-type")
//        private String mimeType;
//
//        @ApiModelProperty(value = "常见的文件类型（IMAGE-图片，AUDIO-音频，VIDEO-视频），为空则表示不常见")
//        private FileTypeEnum fileType;
//
//        @ApiModelProperty(value = "上传时间")
//        private LocalDateTime uploadTime;
//
//        @ApiModelProperty(value = "文件路径")
//        private String filePath;
//
//        @ApiModelProperty(value = "宽度，图片时有值")
//        private Integer width;
//
//        @ApiModelProperty(value = "高度，图片时有值")
//        private Integer height;
//
//        @ApiModelProperty(value = "文件预览url")
//        private String urlPreview;
//
//        @ApiModelProperty(value = "文件下载url")
//        private String urlDownload;
//
//        @ApiModelProperty(value = "文件删除url")
//        private String urlDelete;
//
//        @ApiModelProperty(value = "外部可访问的完整链接")
//        private String url;
//
//        @ApiModelProperty(value = "扩展参数")
//        private Object extraInfo;
//    }
}
