package com.elitescloud.cloudt.ucenter.convert;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitescloud.cloudt.ucenter.api.dto.WebsiteAppearanceDTO;
import com.elitescloud.cloudt.ucenter.api.vo.resp.WebsiteAppearanceVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.WebsiteAppearanceSaveVO;
import com.elitescloud.cloudt.ucenter.entity.WebsiteAppearanceDO;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

/**
 * 网站外观配置信息表
 *
 * @author chaofeng.xia
 * @date 2023/5/23 16:12
 */
@Mapper(config = BaseMapperConfig.class)
public interface WebsiteAppearanceConvert {

    WebsiteAppearanceConvert INSTANCE = Mappers.getMapper(WebsiteAppearanceConvert.class);

    /**
     * do转Vo
     *
     * @param demoDO Do
     * @return vo
     */
    WebsiteAppearanceVO do2Vo(WebsiteAppearanceDO demoDO);

    /**
     * do转saveVo
     *
     * @param demoDO saveDo
     * @return vo
     */
    WebsiteAppearanceSaveVO do2SaveVo(WebsiteAppearanceDO demoDO);

    /**
     * do转dto
     *
     * @param websiteAppearanceDO do
     * @return dto
     */
    WebsiteAppearanceDTO do2Dto(WebsiteAppearanceDO websiteAppearanceDO);


    /**
     * saveVo转do
     *
     * @param websiteAppearanceSaveVO saveVo
     * @return do
     */
    WebsiteAppearanceDO saveVo2Do(WebsiteAppearanceSaveVO websiteAppearanceSaveVO);

}
