package com.elitescloud.cloudt.ucenter.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 网站栏目配置
 *
 * @author chaofeng.xia
 * @date 2023/5/23 15:21
 */
@Entity
@Table(name = "sys_website_bar")
@org.hibernate.annotations.Table(appliesTo = "sys_website_bar", comment = "网站栏目配置")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class WebsiteBarDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2940503672919506239L;

    @Column(name = "bar_name")
    private String barName;

    @Column(name = "bar_type")
    private String barType;

    @Column(name = "bar_code")
    private String barCode;

    @Column(name = "target_type")
    private String targetType;

    @Column(name = "window_open_mode")
    private String windowOpenMode;

    @Column(name = "home_page_flag")
    private Boolean homePageFlag;

    @Column(name = "mall_mode")
    private String mallMode;

    @Column(name = "link_address")
    private String linkAddress;

    @Column(name = "link_address_id")
    private Long linkAddressId;

    @Column(name = "link_type")
    private String linkType;

    @Column(name = "show_flag")
    private Boolean showFlag;

    @Column(name = "sort_no")
    private Integer sortNo;

    @Column(name = "pid")
    private Long pid;

    @Column(name = "p_name")
    private String pName;

}
