package com.elitescloud.cloudt.ucenter.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.ucenter.api.vo.param.*;
import com.elitescloud.cloudt.ucenter.api.vo.resp.*;
import com.elitescloud.cloudt.ucenter.api.vo.save.ArticleCategorySaveVO;
import com.elitescloud.cloudt.ucenter.api.vo.save.ArticleInfoSaveVO;

import java.util.List;

public interface ArticleManageService {

    PagingVO<ArticleCategoryRespVO> search(ArticleCategoryPagingParam searchParam);

    Long saveOrUpdateArticleCategory(ArticleCategorySaveVO saveVO);

    Long deleteArticleCategory(Long id);

    Long deleteArticleInfo(Long id);

    Long saveOrUpdateArticleInfo(ArticleInfoSaveVO saveVO);

//    List<ArticleCategoryRespVO> queryUpCategory();

    List<UpCategoryRespVO> queryUpCategory(Long id);

    Long categoryShowUpdate(CategoryShowParam param);

    Integer categorySortUpdate(ArticleCategorySortParam param);

    Integer infoShowUpdate(ArticleInfoShowParam param);

    Integer infoSortUpdate(ArticleInfoSortParam param);

    PagingVO<ArticleInfoRespVO> infoSearch(ArticleInfoPagingParam searchParam);

    ArticleInfoDetailRespVO queryInfoDetail(Long id);

    List<ArticleInfoCategoryRespVO> queryAllCategory();

    String queryArticleDetail(Long id);

    List<CategoryArticleRespVO> queryCategoryArticle();

}
