ALTER TABLE sys_employee_org
    ADD position_id BIGINT NULL COMMENT '岗位ID';

CREATE TABLE `sys_position`
(
    `id`                   bigint       NOT NULL COMMENT '记录唯一ID',
    `position_code`        varchar(255) DEFAULT NULL,
    `position_name`        varchar(255) NOT NULL,
    `position_description` varchar(255) DEFAULT NULL,
    `tenant_id`            bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`        bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`        bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`               varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`       bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`              varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`          datetime     DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`       bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`              varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`          datetime     DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`          int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`   int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`            bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`          bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`            bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) COMMENT ='岗位';

CREATE TABLE `sys_position_org`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `position_code`      varchar(255) NOT NULL,
    `org_code`           varchar(255) NOT NULL,
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) COMMENT ='岗位组织关联';

CREATE TABLE `sys_position_role`
(
    `id`                 bigint       NOT NULL COMMENT '记录唯一ID',
    `position_code`      varchar(255) NOT NULL,
    `role_code`          varchar(255) NOT NULL,
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) COMMENT ='岗位角色关联';
