package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.service.model.BaseStdModel;
import io.swagger.annotations.ApiModel;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;
import org.hibernate.Hibernate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Version;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * <pre>取号下一编号</pre>
 *
 * @author Michael Li
 * 2022-10-10
 **/

@Entity
@Table(name = "sys_platform_next_number")
@org.hibernate.annotations.Table(appliesTo = "sys_platform_next_number", comment = "取号下一编号表")
@Getter
@Setter
@ToString
@RequiredArgsConstructor
@Accessors(chain = true)
@ApiModel(value = "取号下一编号表", description = "取号下一编号表")
public class SysPlatformNextNumberDO extends BaseStdModel {
    private static final long serialVersionUID = 8103746715455248936L;

    @Comment("应用编码")
    @Column
    private String appCode;

    @Comment("下一编号代码")
    @Column(nullable = false)
    private String code;

    @Comment("下一编号名称")
    @Column(nullable = false)
    private String name;

    @Comment("下一编号步长")
    @Column()
    private Integer step;

    @Comment("下一编号取值")
    @Column()
    private Long nextNumber;

    @Comment("下一编号周期")
    @Column()
    private String nnPeriod;

    @Comment("发号时间")
    @Column()
    private LocalDateTime nnTime;

    @Comment("乐观锁标记")
    @Column
    @Version
    private Integer version;

    @Comment(value = "是否启用", defaultValue = "1")
    @Column()
    private Boolean enabled;

    /**
     * 是否系统内置
     */
    @Comment(value = "是否系统内置", defaultValue = "1")
    @Column()
    private Boolean internal;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass(this) != Hibernate.getClass(o)) {
            return false;
        }
        SysPlatformNextNumberDO that = (SysPlatformNextNumberDO) o;
        return getId() != null && Objects.equals(getId(), that.getId());
    }

    @Override
    public int hashCode() {
        return getClass().hashCode();
    }
}
