package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.constant.SysRoleBusiness;
import com.elitescloud.cloudt.system.service.common.constant.BelongType;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 系统角色.
 * <p>
 * 权限的集合体，通过将角色与权限绑定后，给用户分配角色即可
 *
 * @author Kaiser（wang shao）
 * 2022/9/15
 */
@Entity
@Table(name = "sys_role", indexes = {
        @Index(name = "idx_role_code", columnList = "code"),
        @Index(name = "idx_role_type", columnList = "type"),
        @Index(name = "idx_role_group", columnList = "groupId"),
        @Index(name = "idx_role_parent", columnList = "parentCode"),
        @Index(name = "idx_role_type_id", columnList = "typeId"),
        @Index(name = "idx_role_business", columnList = "businessKey"),
})
@Comment("角色")
@Getter
@Setter
public class SysRoleDO extends BaseModel {
    private static final long serialVersionUID = 4914452434268238530L;

    public static final long DEFAULT_GROUP_ID = -1L;
    public static final String DEFAULT_GROUP_NAME = "默认分组";

    @Column(nullable = false)
    @Comment("角色编码")
    private String code;

    @Column(nullable = false)
    @Comment("角色名称")
    private String name;

    @Column()
    @Comment(value = "是否启用", defaultValue = "1")
    private Boolean enabled;

    @Column()
    @Comment(value = "分组ID", defaultValue = "-1")
    private Long groupId;

    @Column()
    @Comment(value = "上级角色编码", defaultValue = "''")
    private String parentCode;

    /**
     * 角色归属类型
     * {@link BelongType}
     */
    @Column()
    @Comment(value = "角色类型")
    private String type;

    @Column()
    @Comment(value = "类型标识")
    private String typeId;

    /**
     * {@link SysRoleBusiness}
     */
    @Column()
    @Comment(value = "业务标识，[UDC]cloudt-system:roleBusiness", defaultValue = "'sys'")
    private String businessKey;

    @Override
    public int hashCode() {
        return getId().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SysRoleDO) {
            SysRoleDO the = (SysRoleDO) obj;
            if (getId() == null) {
                return the.getId() == null;
            }
            return getId().equals(the.getId());
        }
        return false;
    }
}