package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.constant.SheetLimitStrategy;
import com.elitescloud.cloudt.system.service.model.BaseStdModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.*;
import java.util.Objects;

import static javax.persistence.EnumType.STRING;

/**
 * 导入导出模板.
 *
 * @author Kaiser（wang shao）
 * @date 2/15/2023
 */
@Entity
@Table(name = "sys_tmpl", indexes = {
        @Index(name = "idx_tmpl_app", columnList = "appCode"),
        @Index(name = "idx_tmpl_code", columnList = "code_", unique = true),
})
@Comment("导入导出模板")
@DynamicInsert
@Getter
@Setter
public class SysTmplDO extends BaseStdModel {
    private static final long serialVersionUID = -6618860402867791662L;

    @Column(nullable = false)
    @Comment("模板名称")
    private String name;

    @Column(nullable = false)
    @Comment("应用编码")
    private String appCode;

    @Column(name = "code_", nullable = false)
    @Comment("模板编号")
    private String code;

    @Column()
    @Comment("模板文件标识")
    private String fileCode;

    @Column()
    @Comment("模板文件名称")
    private String fileName;

    @Column()
    @Comment(value = "是否是导出模板", defaultValue = "1")
    private Boolean export;

    @Column()
    @Comment("头部所占行数，头部以下都是数据部分")
    private Integer headRow;

    @Column()
    @Comment("数据字段类型所在行，fieldTypeRow不能大于headRow")
    private Integer fieldTypeRow;

    @Column()
    @Comment(value = "是否启用", defaultValue = "1")
    private Boolean enabled;

    @Column()
    @Comment(value = "导入（或导出）数据限制，每次允许导入（或导出）的记录数量，-1表示无限制", defaultValue = "-1")
    private Integer dataLimitPer;

    @Column()
    @Comment(value = "异步导入（或导出）阀值，导入（或导出）数据超过阀值后将转为异步的方式，-1表示无限制", defaultValue = "-1")
    private Integer asyncThreshold;

    @Column()
    @Comment(value = "并发限制，同一模板可并发导入（或导出）的最大数量，-1表示无限制", defaultValue = "-1")
    private Integer concurrentLimit;

    @Column()
    @Lob
    @Comment("属性列表")
    private String attributeList;

    // 导出特有的字段

    @Column()
    @Comment(value = "导出时每个sheet限制的记录数，最大100万", defaultValue = "1000000")
    private Integer exportSheetLimit;

    /**
     * {@link SheetLimitStrategy}
     */
    @Column()
    @Comment("导出时超出sheet限制后的策略")
    @Enumerated(value = STRING)
    private SheetLimitStrategy exportSheetStrategy;

    // 导入特有的字段

    @Column()
    @Comment("需要解析导入的sheet页，从1开始，多个之间以逗号分隔")
    private String sheetNos;

    @Override
    public int hashCode() {
        return Objects.hashCode(getId());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SysTmplDO) {
            SysTmplDO the = (SysTmplDO) obj;
            if (getId() == null) {
                return the.getId() == null;
            }
            return getId().equals(the.getId());
        }
        return false;
    }
}
