package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.service.common.constant.BusinessObjectParamInEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 业务操作的参数.
 *  当前获取的是API的出参 对应VO
 * @author Kaiser（wang shao）
 * @date 2024/3/6
 */
@Entity
@Table(name = "sys_business_operation_param", indexes = {
        @Index(name = "idx_business_opera_param_openapi", columnList = "openApiCode"),
        @Index(name = "idx_business_opera_param_obj", columnList = "businessObjectId"),
        @Index(name = "idx_business_opera_param_operation", columnList = "businessOperationId"),
})
@Comment("业务操作的参数")
@DynamicInsert
@Getter
@Setter
public class SysBusinessOperationParamDO extends BaseModel {
    private static final long serialVersionUID = 7528849790559465996L;

    @Comment(value = "业务对象ID")
    @Column(nullable = false)
    private Long businessObjectId;

    @Comment(value = "业务对象编码")
    @Column()
    private String businessObjectCode;

    @Comment(value = "业务对象操作ID")
    @Column(nullable = false)
    private Long businessOperationId;

    @Comment(value = "业务对象操作编码")
    @Column()
    private String businessOperationCode;

    @Comment(value = "OpenApi的编码")
    @Column()
    private String openApiCode;

    @Comment(value = "OpenApi的操作编码")
    @Column()
    private String openApiOperationCode;

    @Comment(value = "字段名称")
    @Column()
    private String fieldName;

    @ApiModelProperty(value = "是否过滤权限字段")
    private Boolean fieldPermissionFilter;

    @Comment(value = "字段描述")
    @Column()
    private String fieldDescription;

    @Comment(value = "是否为请求参数", defaultValue = "1")
    @Column()
    private Boolean request;

    @Comment(value = "字段类型")
    @Column()
    private String fieldType;

    @Comment(value = "字段类型(java)")
    @Column()
    private String fieldJavaType;

    @Comment(value = "是否有依赖")
    @Column()
    private Boolean ref;

    @Comment(value = "依赖地址")
    @Column()
    private String refValue;

    @Comment(value = "参数深度")
    @Column()
    private Integer depth;

    @Comment(value = "参数路径")
    @Column()
    private String paramPath;

    @Comment(value = "是否是ApiResult的参数", defaultValue = "0")
    @Column()
    private Boolean apiResult;

    @Comment(value = "是否是PagingVO的参数", defaultValue = "0")
    @Column()
    private Boolean pagingResult;

    @Comment(value = "是否必须", defaultValue = "0")
    @Column()
    private Boolean required;

    @Comment(value = "是否已过期", defaultValue = "0")
    @Column()
    private Boolean deprecated;

    /**
     * 取值：{@link BusinessObjectParamInEnum}
     */
    @Comment(value = "参数位置")
    @Column()
    private String paramIn;

    @Comment(value = "是否是单值", defaultValue = "0")
    @Column()
    private Boolean single;

    /**
     * 取值：{@link com.elitescloud.cloudt.system.service.common.constant.BusinessObjectCollectionTypeEnum}
     */
    @Comment(value = "集合类型")
    @Column()
    private String collectionType;

    /**
     * 取值：{@link com.elitescloud.cloudt.system.service.common.constant.BusinessObjectSourceEnum}
     */
    @Comment(value = "数据来源")
    @Column()
    private String dataSource;

    @Comment(value = "是否启用", defaultValue = "1")
    @Column()
    private Boolean enabled;
}
