package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.service.common.constant.TableNameConstant;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Objects;

/**
 * 角色-应用-菜单-API-列权限字段权限字符串表 data permission column
 *
 * @author chen
 */
@Entity
@Table(name = TableNameConstant.SYS_DPCR_API_FIELDS_DO, indexes = {
        @Index(name = "idx_dpcr_api_field_role", columnList = "roleId"),
        @Index(name = "idx_dpcr_api_field_app", columnList = "appCode"),
        @Index(name = "idx_dpcr_api_field_menu", columnList = "menuCode"),
        @Index(name = "idx_dpcr_api_field_api", columnList = "apiCode"),
})
@Comment("角色-应用-菜单-API-列权限字段权限字符串表")
@Getter
@Setter
@DynamicInsert
@DynamicUpdate
public class SysDpcrApiFieldsDO extends BaseModel {
    private static final long serialVersionUID = 8283151170374438635L;

    @Comment("角色id")
    @Column()
    private Long roleId;

    @Comment("应用编码")
    @Column
    private String appCode;

    @Comment("菜单编码")
    @Column()
    private String menuCode;

    @Comment("接口编码")
    @Column
    private String apiCode;

    @Comment("字段名称")
    @Column()
    private String fieldName;

    @Comment("字段描述")
    @Column()
    private String fieldRemark;

    @Comment("api可见")
    @Column()
    private Boolean fieldApiVisible;

    @Comment("表单可见")
    @Column()
    private Boolean fieldFormVisible;

    @Comment("表单可编辑")
    @Column()
    private Boolean fieldFormUpdate;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SysDpcrApiFieldsDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SysDpcrApiFieldsDO entity = (SysDpcrApiFieldsDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}