package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.common.annotation.BusinessParam;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Objects;

/**
 * 员工组.
 *
 * @author Kaiser（wang shao）
 * @date 2023/2/2
 */
@Entity
@Table(name = "sys_emp_group", indexes = {
        @Index(name = "idx_emp_group_code", columnList = "code"),
        @Index(name = "idx_emp_group_type", columnList = "type"),
})
@Comment("员工组")
@DynamicInsert
@Getter
@Setter
public class SysEmpGroupDO extends BaseModel {
    private static final long serialVersionUID = 6588494607367488040L;

    @Comment(value = "员工组编号")
    @Column(nullable = false)
    private String code;

    @Comment(value = "员工组名称")
    @Column(nullable = false)
    private String name;

    @Comment(value = "类型，[UDC]cloudt-system:empGroupType")
    @Column()
    @BusinessParam(dataPermissionEnabled = true, fieldPermissionEnabled = true)
    private String type;

    @Comment(value = "顺序", defaultValue = "0")
    @Column()
    private Integer sortNo;

    @Comment(value = "是否启用", defaultValue = "1")
    @Column()
    @BusinessParam(dataPermissionEnabled = true, fieldPermissionEnabled = true)
    private Boolean enabled;

    @Override
    public int hashCode() {
        return Objects.hashCode(getId());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SysEmpGroupDO) {
            SysEmpGroupDO the = (SysEmpGroupDO) obj;
            if (getId() == null) {
                return the.getId() == null;
            }
            return getId().equals(the.getId());
        }
        return false;
    }
}
