package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 员工组织关系.
 *
 * @author Kaiser（wang shao）
 * 2022/9/19
 */
@Entity
@Table(name = "sys_employee_org", indexes = {
        @Index(name = "idx_sys_emp_org_user_id", columnList = "userId"),
        @Index(name = "idx_sys_emp_org_emp_id", columnList = "employeeId"),
        @Index(name = "idx_sys_emp_org_root_org_id", columnList = "rootOrgId"),
        @Index(name = "idx_sys_emp_org_org_id", columnList = "orgId"),
        @Index(name = "idx_sys_emp_org_leader", columnList = "leaderUserId"),
        @Index(name = "idx_emp_org_leader_emp", columnList = "leaderEmployeeId"),
})
@Comment("员工组织")
@Getter
@Setter
public class SysEmployeeOrgDO extends BaseModel {
    private static final long serialVersionUID = 5679081674228798174L;

    @Column(nullable = false)
    @Comment("用户账号ID")
    private Long userId;

    @Column(nullable = false)
    @Comment("员工ID")
    private Long employeeId;

    @Column(nullable = false)
    @Comment("所属根组织ID")
    private Long rootOrgId;

    @Column(nullable = false)
    @Comment("所属组织ID")
    private Long orgId;

    @Column()
    @Comment("员工所在组织的岗位ID")
    private Long positionId;

    @Column()
    @Comment("领导用户ID")
    private Long leaderUserId;

    @Column()
    @Comment("领导的员工ID")
    private Long leaderEmployeeId;

    @Column(nullable = false)
    @Comment("加入时间")
    private LocalDateTime joinTime;

    @Column()
    @Comment("是否是默认组织")
    private Boolean def;

    @Column()
    @Comment(value = "是否负责人", defaultValue = "0")
    private Boolean assignee;

    @Override
    public int hashCode() {
        return Objects.hashCode(getId());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SysEmployeeOrgDO) {
            SysEmployeeOrgDO the = (SysEmployeeOrgDO) obj;
            if (getId() == null) {
                return the.getId() == null;
            }
            return getId().equals(the.getId());
        }
        return false;
    }
}
