package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 角色关联.
 *
 * @author Kaiser（wang shao）
 * @date 2025/7/6 周日
 */
@Entity
@Table(name = "sys_role_related", indexes = {
        @Index(name = "idx_role_related_relatedid", columnList = "relatedId"),
        @Index(name = "idx_role_related_role", columnList = "roleCode"),
})
@Comment("角色关联")
@Getter
@Setter
public class SysRoleRelatedDO extends BaseModel {
    private static final long serialVersionUID = 8881243407098316461L;

    /**
     * 关联类型
     *
     * @see com.elitescloud.cloudt.system.service.common.constant.SysInnerConstant
     */
    @Comment(value = "关联类型")
    @Column(nullable = false)
    private String relatedType;

    @Comment(value = "关联标识")
    @Column(nullable = false)
    private String relatedId;

    @Comment(value = "角色（组）编码")
    @Column(nullable = false)
    private String roleCode;

    @Comment(value = "是否是角色组")
    @Column()
    private Boolean roleGroup;
}
