package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Objects;

/**
 * 租户自定义行政区域.
 * 租户是否启用自定义行政区域
 *
 * @author Kaiser（wang shao）
 * @date 2023/1/30
 */
@Entity
@Table(name = "sys_tenant_area", indexes = {
        @Index(name = "idx_sys_tenant_area_tenant", columnList = "sysTenantId", unique = true),
})
@Comment("租户自定义行政区域")
@DynamicInsert
@Getter
@Setter
public class SysTenantAreaDO extends BaseModel {
    private static final long serialVersionUID = -2786009878073332650L;

    @Column(nullable = false)
    @Comment("租户ID")
    private Long sysTenantId;

    @Column(nullable = false)
    @Comment(value = "是否启用自定义行政区域", defaultValue = "0")
    private Boolean enabled;

    @Override
    public int hashCode() {
        return Objects.hashCode(getId());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SysTenantAreaDO) {
            SysTenantAreaDO the = (SysTenantAreaDO) obj;
            if (getId() == null) {
                return the.getId() == null;
            }
            return getId().equals(the.getId());
        }
        return false;
    }
}
