package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.time.LocalDateTime;

/**
 * 用户与外部应用的关系.
 *
 * @author Kaiser（wang shao）
 * @date 2025/2/11
 */
@Entity
@Table(name = "sys_user_outerapp", indexes = {
        @Index(name = "idx_user_outerapp_user", columnList = "userId"),
        @Index(name = "idx_user_outerapp_outerapp", columnList = "outerAppId"),
        @Index(name = "idx_user_outerapp_openid", columnList = "openId"),
        @Index(name = "idx_user_outerapp_key", columnList = "userId,openId,outerAppId", unique = true),
})
@Comment("用户角色关联表")
@Getter
@Setter
public class SysUserOuterappDO extends BaseModel {
    private static final long serialVersionUID = -2970681002561680804L;

    @Comment("用户ID")
    @Column(nullable = false)
    private Long userId;

    @Comment("外部应用ID")
    @Column(nullable = false)
    private String outerAppId;

    @Comment("外部应用的用户标识")
    @Column(nullable = false)
    private String openId;

    @Comment("外部应用的用户标识2")
    @Column()
    private String unionId;

    @Comment("绑定时间")
    @Column()
    private LocalDateTime bindTime;

    @Comment("租户编码")
    @Column()
    private String tenantCode;
}
