package com.elitescloud.cloudt.system.service.model.entity;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.core.support.customfield.common.JsonStringMapConverter;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.springframework.util.StringUtils;

import javax.persistence.*;
import java.time.LocalDateTime;
import java.util.Map;

/**
 * 账号同步记录.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/30
 */
@Entity
@Table(name = "sys_user_sync_record", indexes = {
        @Index(name = "idx_sys_user_syncrd_outersys", columnList = "outerSysCode"),
        @Index(name = "idx_sys_user_syncrd_user", columnList = "userId"),
        @Index(name = "idx_sys_user_syncrd_username", columnList = "username"),
        @Index(name = "idx_sys_user_syncrd_time", columnList = "syncTime"),
})
@Comment("账号同步记录")
@Getter
@Setter
public class SysUserSyncRecordDO extends BaseModel {
    private static final long serialVersionUID = 2093866874512125359L;

    @Comment(value = "外部系统编码")
    @Column(nullable = false)
    private String outerSysCode;

    @Comment(value = "账户ID")
    @Column(nullable = false)
    private Long userId;

    @Comment(value = "登录号")
    @Column()
    private String username;

    @Comment("姓名-姓氏")
    @Column()
    private String lastName;

    @Comment("姓名-名字")
    @Column()
    private String firstName;

    @Comment("手机号")
    @Column()
    private String mobile;

    @Comment("邮箱")
    @Column()
    private String email;

    @Column()
    @Comment("身份证号")
    private String idCard;

    @Column()
    @Comment("同步时间")
    private LocalDateTime syncTime;

    @Column()
    @Comment(value = "是否同步成功", defaultValue = "0")
    private Boolean syncSuccess;

    @Column()
    @Comment("同步结束时间")
    private LocalDateTime syncFinishTime;

    @Comment(value = "同步失败信息")
    @Column()
    @Lob
    private String failReason;

    @Comment(value = "同步失败的详细信息")
    @Column()
    @Lob
    private String failReasonDetail;

    @Comment(value = "回执信息")
    @Column()
    @Lob
    private String receipt;

    @Comment(value = "外部系统用户ID")
    @Column()
    private String outerUserId;

    @Comment(value = "外部系统用户编码")
    @Column()
    private String outerUserCode;

    @Comment(value = "同步接口地址")
    @Column()
    private String syncUrl;

    @Comment(value = "同步的数据信息")
    @Column()
    @Lob
    @Convert(converter = JsonStringMapConverter.class)
    private Map<String, Object> syncData;

    public String getFullName() {
        if (!StringUtils.hasText(lastName)) {
            return firstName;
        }

        return lastName + CharSequenceUtil.blankToDefault(firstName, "");
    }

}
