package com.elitescloud.cloudt.system.service.vo.save;

import com.elitescloud.cloudt.common.constant.Terminal;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2021/09/28
 */
@Data
@ApiModel(description = "用户与终端绑定")
public class SysUserTerminalSaveVO implements Serializable {
    private static final long serialVersionUID = -91435808471956421L;

    @ApiModelProperty(value = "用户ID", position = 1)
    @NotBlank(message = "请选择绑定用户")
    private Long userId;

    @ApiModelProperty(value = "绑定的终端", position = 2)
    private Set<Terminal> terminals;
}
