package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.common.annotation.BusinessParam;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.constant.TaxRateType;
import com.elitescloud.cloudt.system.service.model.BaseStdModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 税率.
 *
 * @author Kaiser（wang shao）
 * @date 2023/2/1
 */
@Entity
@Table(name = "sys_tax_rate", indexes = {
        @Index(name = "idx_tax_rate_type", columnList = "taxRateType"),
        @Index(name = "idx_tax_rate_no", columnList = "taxRateNo"),
})
@Comment("税率")
@DynamicInsert
@Getter
@Setter
public class SysTaxRateDO extends BaseStdModel {
    private static final long serialVersionUID = 107469229517630221L;

    /**
     * {@link TaxRateType}
     */
    @Comment("税率类型，UDC[cloudt-system:taxRateType]")
    @Column()
    @BusinessParam(dataPermissionEnabled = true, fieldPermissionEnabled = true)
    private String taxRateType;

    @Comment("税率编号")
    @Column(nullable = false)
    private String taxRateNo;

    @Comment("税率说明")
    @Column()
    private String taxRateDesc;

    @Comment("生效日期")
    @Column()
    private LocalDateTime validFrom;

    @Comment("失效日期")
    @Column()
    private LocalDateTime validTo;

    @Comment("税率值")
    @Column(precision = 20, scale = 6)
    private BigDecimal taxRateValue;

    @Comment(value = "是否启用", defaultValue = "1")
    @Column()
    @BusinessParam(dataPermissionEnabled = true, fieldPermissionEnabled = true)
    private Boolean enabled;

    @Override
    public int hashCode() {
        return Objects.hashCode(getId());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SysTaxRateDO) {
            SysTaxRateDO the = (SysTaxRateDO) obj;
            if (getId() == null) {
                return the.getId() == null;
            }
            return getId().equals(the.getId());
        }
        return false;
    }
}
