package com.elitescloud.cloudt.system.service.util;


import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import org.springframework.util.StringUtils;

import java.util.function.BiFunction;
import java.util.function.Function;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/9/9 22:35
 */


public class JpaPredicateBuilder {
    private BooleanBuilder booleanBuilder = new BooleanBuilder();

    private JpaPredicateBuilder() {
    }

    public static JpaPredicateBuilder builder() {
        return new JpaPredicateBuilder();
    }


    public Predicate getPredicate() {
        return booleanBuilder;
    }


    public <T> JpaPredicateBuilder or(Function<T, BooleanExpression> expressionSupplier,T value) {
        if(value != null) {
            if (value instanceof String) {
                if(!StringUtils.hasText((String)value)){
                    return this;
                }
            }
            this.booleanBuilder.or(expressionSupplier.apply(value));
        }
        return this;
    }
    public <T1, T2> JpaPredicateBuilder or(BiFunction<T1, T2, BooleanExpression> expressionSupplier, T1 value1, T2 value2) {
        if(value1 != null && value2 != null) {
            this.booleanBuilder.or(expressionSupplier.apply(value1, value2));
        }
        if(value1 != null && value2 == null) {
            throw new RuntimeException("区间必须起始参数必填");
        }
        if(value1 == null && value2 != null) {
            throw new RuntimeException("区间必须起始参数必填");
        }
        return this;
    }
    public <T> JpaPredicateBuilder and(Function<T, BooleanExpression> expressionSupplier,T value) {
        if(value != null) {
            if (value instanceof String) {
                if(!StringUtils.hasText((String)value)){
                    return this;
                }
            }
             this.booleanBuilder.and(expressionSupplier.apply(value));
        }
        return this;
    }
    public <T1, T2> JpaPredicateBuilder and(BiFunction<T1, T2, BooleanExpression> expressionSupplier, T1 value1, T2 value2) {
        if(value1 != null && value2 != null) {
            this.booleanBuilder.and(expressionSupplier.apply(value1, value2));
        }
        if(value1 != null && value2 == null) {
           throw new RuntimeException("区间必须起始参数必填");
        }
        if(value1 == null && value2 != null) {
            throw new RuntimeException("区间必须起始参数必填");
        }
        return this;
    }

}
