package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 菜单树.
 * <p>
 * 租户级的菜单树，允许每个租户拥有自己的菜单树
 *
 * @author Kaiser（wang shao）
 * 2022/9/15
 */
@Entity
@Table(name = "sys_tenant_menu_tree", indexes = {
        @Index(name = "idx_tenant_menu_tree_menu", columnList = "menuCode"),
        @Index(name = "idx_tenant_menu_tree_parent", columnList = "parentMenuCode"),
})
@Comment("自定义菜单树")
@Getter
@Setter
public class SysTenantMenuTreeDO extends BaseModel {
    private static final long serialVersionUID = 8711035803163200856L;

    @Column(nullable = false)
    @Comment("菜单编码")
    private String menuCode;

    @Column()
    @Comment("菜单名称")
    private String menuName;

    /**
     * {@link com.elitescloud.cloudt.system.service.common.constant.MenuTreeNodeType}
     */
    @Column()
    @Comment("节点类型（MENU_GROUP-菜单分组，MENU-菜单）")
    private String nodeType;

    @Column
    @Comment(value = "父菜单编码")
    private String parentMenuCode;

    @Column()
    @Comment("菜单图标")
    private String icon;

    @Column
    @Comment(value = "是否自定义菜单", defaultValue = "0")
    @Deprecated(since = "3.3.0")
    private Boolean custom;

    @Column
    @Comment(value = "排序号", defaultValue = "0")
    private Integer sortNo;

    @Column
    @Comment(value = "是否启用", defaultValue = "0")
    private Boolean enabled;

    @Override
    public int hashCode() {
        return getId().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SysTenantMenuTreeDO) {
            SysTenantMenuTreeDO the = (SysTenantMenuTreeDO) obj;
            if (getId() == null) {
                return the.getId() == null;
            }
            return getId().equals(the.getId());
        }
        return false;
    }
}
