package com.elitescloud.cloudt.system.service.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2021/09/16
 */
@ApiModel(description = "修改密码")
@Data
public class SysPasswordUpdateParam implements Serializable {
    private static final long serialVersionUID = 8430483914823578416L;

    @ApiModelProperty(value = "账号", position = 1, required = true)
    @NotBlank(message = "手机号不能为空")
    private String account;

    @ApiModelProperty(value = "账号类型（mobile-手机号，email-邮箱，目前仅支持手机号），默认手机号", position = 2)
    private String accountType;

    @ApiModelProperty(value = "验证码", position = 3, required = true)
    @NotBlank(message = "验证码不能为空")
    private String verifyCode;

    @ApiModelProperty(value = "密码", position = 4, required = true)
    @NotBlank(message = "密码不能为空")
    private String password;
}
