package com.elitescloud.cloudt.system.service.callback;

import com.elitescloud.cloudt.system.service.model.bo.SysUserSaveBO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;

/**
 * 用户变更相关回调接口.
 *
 * @author Kaiser（wang shao）
 * 2022/9/23
 */
public interface UserChangedCallback {

    /**
     * 用户保存后的回调
     *
     * @param add    是否是新增操作
     * @param saveBO 保存参数
     * @param userDO 用户entity
     */
    void onUpsert(boolean add, SysUserSaveBO saveBO, SysUserDO userDO);

    /**
     * 启用、禁用
     *
     * @param userId  用户ID
     * @param enabled 是否是启用操作
     */
    void onEnabled(Long userId, boolean enabled);

    /**
     * 修改密码
     *
     * @param userId   用户ID
     * @param password 新密码
     * @deprecated 请使用 {@link #onUpdatePassword(Long, String, String)}
     */
    @Deprecated()
    default void onUpdatePassword(Long userId, String password) {
        onUpdatePassword(userId, password, null);
    }

    /**
     * 修改密码
     *
     * @param userId           用户ID
     * @param password         新密码
     * @param originalPassword 原始密码
     */
    void onUpdatePassword(Long userId, String password, String originalPassword);

    /**
     * 修改手机号
     *
     * @param userId 用户ID
     * @param mobile 手机号
     */
    void onUpdateMobile(Long userId, String mobile);

    /**
     * 修改邮箱
     *
     * @param userId 用户ID
     * @param email  邮箱
     */
    void onUpdateEmail(Long userId, String email);

    /**
     * 删除操作
     *
     * @param userId    用户ID
     * @param casUserId 统一身份认证ID
     */
    void onDelete(Long userId, Long casUserId);
}
