package com.elitescloud.cloudt.system.service.model.bo;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 组织保存信息.
 *
 * @author Kaiser（wang shao）
 * 2022/9/29
 */
@Data
public class SysOrgSaveBO {

    /**
     * 组织ID
     */
    private Long id;

    /**
     * 上级组织编码
     */
    private String parentCode;

    /**
     * 是否行政组织
     */
    @NotNull
    private Boolean executive;

    /**
     * 组织编码
     */
    @NotBlank
    private String code;

    /**
     * 外部组织编码
     */
    private String outerCode;

    /**
     * 组织名称
     */
    @NotBlank
    private String name;

    /**
     * 简称
     */
    private String shortName;

    /**
     * 英文名称
     */
    private String englishName;

    /**
     * 组织类型 [UDC]ORG_TYPE
     */
    private String type;

    /**
     * 是否实体组织
     */
    private Boolean entity;

    /**
     * 顺序
     */
    private Integer sortNo;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 是否向外同步
     */
    private Boolean syncOuter;

    /**
     * 所属公司ID
     */
    private Long ouId;

    /**
     * 区域
     */
    private String region;

    /**
     * 事业部
     * <p>
     * [UDC]cloudt-system:businessUnit {@link com.elitescloud.cloudt.constant.SysBusinessUnit}
     */
    private String businessUnit;

    /**
     * 利润中心
     * <p>
     * [UDC]cloudt-system:profitablyCenter {@link com.elitescloud.cloudt.constant.SysProfitablyCenter}
     */
    private String profitablyCenter;

    /**
     * 职能类型
     * <p>
     * [UDC]cloudt-system:functionType {@link com.elitescloud.cloudt.constant.SysFunctionType}
     */
    private String functionType;

    /**
     * 备注
     */
    private String remark;
}
