package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.*;

/**
 * OpenAPI资源信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/6
 */
@Entity
@Table(name = "sys_openapi_resource", indexes = {
        @Index(name = "idx_openapi_res_openapi", columnList = "openApiInfoId"),
})
@Comment("OpenAPI资源信息")
@DynamicInsert
@Getter
@Setter
public class SysOpenApiResourceDO extends BaseModel {
    private static final long serialVersionUID = -3971655573108280669L;

    @Comment(value = "openApi信息ID")
    @Column(nullable = false)
    private Long openApiInfoId;

    @Comment(value = "资源内容字符串")
    @Column()
    @Lob
    private String resource;

    @Comment(value = "资源内容byte")
    @Column()
    @Lob
    private byte[] resourceByte;

    @Comment(value = "排序", defaultValue = "0")
    @Column()
    private Integer sortNo;

    @Comment(value = "扩展字段1")
    @Column()
    private String ext1;

    @Comment(value = "扩展字段2")
    @Column()
    private String ext2;
}
