/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.common.constant;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.base.SafeEnum;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import java.io.Serializable;
import java.util.Arrays;
import javax.validation.constraints.NotNull;
import org.springframework.util.StringUtils;

public class BelongType
extends SafeEnum<BelongType> {
    private static final long serialVersionUID = 2642151856062071747L;
    public static final BelongType PLATFORM = new BelongType("platform", "\u5e73\u53f0");
    public static final BelongType TENANT = new BelongType("tenant", "\u79df\u6237");
    public static final BelongType TENANT_ORG = new BelongType("tenant_org", "\u79df\u6237\u7ec4\u7ec7");
    public static final BelongType PERSONAL = new BelongType("personal", "\u4e2a\u4eba");
    public static final BelongType CUSTOM = new BelongType("custom", "\u81ea\u5b9a\u4e49");

    public BelongType() {
    }

    public BelongType(String value) {
        super(value);
    }

    public BelongType(String value, String description) {
        super(value, description);
    }

    public static BelongType valueOf(String value) {
        return (BelongType)((Object)SafeEnum.valueOf(BelongType.class, (String)value));
    }

    public static Belonger getBelonger(boolean defaultPersonal) {
        GeneralUserDetails currentUser = SecurityContextUtil.currentUser();
        BelongType belongType = null;
        String typeId = null;
        if (currentUser == null) {
            SysTenantDTO tenant = ((TenantClientProvider)SpringContextHolder.getBean(TenantClientProvider.class)).getSessionTenant();
            if (tenant != null) {
                belongType = TENANT;
                typeId = tenant.getId().toString();
            } else {
                belongType = PLATFORM;
                typeId = TenantConstant.DEFAULT_TENANT_ID.toString();
            }
            return new Belonger(belongType, typeId);
        }
        if (currentUser.isOperation()) {
            SysTenantDTO tenant = ((TenantClientProvider)SpringContextHolder.getBean(TenantClientProvider.class)).getSessionTenant();
            if (tenant != null) {
                belongType = TENANT;
                typeId = tenant.getId().toString();
            } else {
                belongType = PLATFORM;
                typeId = TenantConstant.DEFAULT_TENANT_ID.toString();
            }
        } else if (currentUser.isTenantAdmin()) {
            belongType = TENANT;
            typeId = currentUser.getTenantId().toString();
        } else if (currentUser.isTenantOrgAdmin()) {
            belongType = TENANT_ORG;
            typeId = currentUser.getTenantOrgId().toString();
        } else if (defaultPersonal) {
            belongType = PERSONAL;
            typeId = currentUser.getUserId().toString();
        } else {
            belongType = CUSTOM;
            typeId = "";
        }
        return new Belonger(belongType, typeId);
    }

    public static String getBelongerId(@NotNull BelongType belongType, String ... belongId) {
        Assert.notNull((Object)((Object)belongType), (String)"\u5f52\u5c5e\u8005\u7c7b\u578b\u4e3a\u7a7a", (Object[])new Object[0]);
        GeneralUserDetails currentUser = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        if (belongType == PLATFORM) {
            return TenantConstant.DEFAULT_TENANT_ID.toString();
        }
        if (belongType == TENANT) {
            return ((Long)ObjUtil.defaultIfNull((Object)currentUser.getTenantId(), (Object)TenantConstant.DEFAULT_TENANT_ID)).toString();
        }
        if (belongType == TENANT_ORG) {
            return ((Serializable)ObjUtil.defaultIfNull((Object)currentUser.getTenantOrgId(), (Object)"")).toString();
        }
        if (belongType == PERSONAL) {
            return ((Serializable)ObjUtil.defaultIfNull((Object)currentUser.getUserId(), (Object)"")).toString();
        }
        if (ArrayUtil.isEmpty((Object[])belongId)) {
            return "";
        }
        CharSequence[] belongerIds = (String[])Arrays.stream(belongId).filter(StringUtils::hasText).toArray(String[]::new);
        return belongerIds.length == 0 ? "" : String.join((CharSequence)":", belongerIds);
    }

    public static Belonger getBelonger() {
        return BelongType.getBelonger(false);
    }

    public static Belonger getBelongerPersonal() {
        GeneralUserDetails currentUser = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        return new Belonger(PERSONAL, currentUser.getUserId().toString());
    }

    public static class Belonger {
        private final BelongType belongType;
        private final String belongId;

        public Belonger(BelongType belongType, String belongId) {
            this.belongType = belongType;
            this.belongId = (String)ObjUtil.defaultIfNull((Object)belongId, (Object)"");
        }

        public BelongType getBelongType() {
            return this.belongType;
        }

        public String getBelongId() {
            return this.belongId;
        }
    }
}

