/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.common.constant;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum JavaTypeEnum {
    STRING("java.lang.String", "\u5b57\u7b26\u4e32", false, true, false, false, false, false, false),
    BOOLEAN("java.lang.Boolean", "\u5e03\u5c14\u503c", true, false, false, false, false, false, true),
    CHARACTER("java.lang.Character", "\u5b57\u7b26", true, true, false, false, false, false, false),
    BYTE("java.lang.Byte", "\u5b57\u8282", true, false, true, true, false, false, false),
    SHORT("java.lang.Short", "\u6574\u6570", true, false, true, true, false, false, false),
    INTEGER("java.lang.Integer", "\u6574\u6570", true, false, true, true, false, false, false),
    LONG("java.lang.Long", "\u957f\u6574\u6570", true, false, true, true, false, false, false),
    FLOAT("java.lang.Float", "\u6570\u5b57", true, false, true, false, true, false, false),
    DOUBLE("java.lang.Double", "\u6570\u5b57", true, false, true, false, true, false, false),
    BOOLEAN_PRIMITIVE("boolean", "\u5e03\u5c14\u503c", true, false, false, false, false, false, true),
    CHARACTER_PRIMITIVE("char", "\u5b57\u7b26", true, true, false, false, false, false, false),
    BYTE_PRIMITIVE("byte", "\u5b57\u8282", true, false, true, true, false, false, false),
    SHORT_PRIMITIVE("short", "\u6574\u6570", true, false, true, true, false, false, false),
    INTEGER_PRIMITIVE("int", "\u6574\u6570", true, false, true, true, false, false, false),
    LONG_PRIMITIVE("lang", "\u957f\u6574\u6570", true, false, true, true, false, false, false),
    FLOAT_PRIMITIVE("float", "\u6570\u5b57", true, false, true, false, true, false, false),
    DOUBLE_PRIMITIVE("double", "\u6570\u5b57", true, false, true, false, true, false, false),
    VOID("java.lang.Void", "\u7a7a", false, false, false, false, false, false, false),
    DATE("java.util.Date", "\u65e5\u671f\u65f6\u95f4", false, false, false, false, false, true, false),
    DATE_SQL("java.sql.Date", "\u65e5\u671f\u65f6\u95f4", false, false, false, false, false, true, false),
    LOCAL_DATE("java.time.LocalDate", "\u65e5\u671f", false, false, false, false, false, true, false),
    LOCAL_DATE_TIME("java.time.LocalDateTime", "\u65e5\u671f\u65f6\u95f4", false, false, false, false, false, true, false),
    LOCAL_TIME("java.time.LocalTime", "\u65f6\u95f4", false, false, false, false, false, true, false);

    private final String javaClass;
    private final String description;
    private final boolean primitive;
    private final boolean string;
    private final boolean number;
    private final boolean integer;
    private final boolean decimal;
    private final boolean datetime;
    private final boolean booleanValue;
    private static final Map<String, JavaTypeEnum> ALL;

    private JavaTypeEnum(String javaClass, String description, boolean primitive, boolean string2, boolean number, boolean integer, boolean decimal, boolean datetime, boolean booleanValue) {
        this.javaClass = javaClass;
        this.description = description;
        this.primitive = primitive;
        this.string = string2;
        this.number = number;
        this.integer = integer;
        this.decimal = decimal;
        this.datetime = datetime;
        this.booleanValue = booleanValue;
    }

    public static JavaTypeEnum parse(String javaClass) {
        return ALL.get(javaClass);
    }

    public String getJavaClass() {
        return this.javaClass;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isString() {
        return this.string;
    }

    public boolean isNumber() {
        return this.number;
    }

    public boolean isInteger() {
        return this.integer;
    }

    public boolean isDecimal() {
        return this.decimal;
    }

    public boolean isDatetime() {
        return this.datetime;
    }

    public boolean isBooleanValue() {
        return this.booleanValue;
    }

    static {
        ALL = Arrays.stream(JavaTypeEnum.values()).collect(Collectors.toMap(JavaTypeEnum::getJavaClass, Function.identity(), (t1, t2) -> t1));
    }
}

