/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.manager;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.param.TreeRespParam;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.context.util.CollectionUtil;
import com.elitescloud.cloudt.context.util.TreeDataUtil;
import com.elitescloud.cloudt.system.cacheable.SysCacheAreaRpcService;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.service.convert.AreaConvert;
import com.elitescloud.cloudt.system.service.model.bo.AreaBO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformAreaDO;
import com.elitescloud.cloudt.system.service.model.vo.CommonAreaTreeRespVO;
import com.elitescloud.cloudt.system.service.repo.AreaRepoProc;
import com.elitescloud.cloudt.system.service.repo.TenantAreaRepoProc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AreaManager {
    @Autowired
    private AreaRepoProc repoProc;
    @Autowired
    private TenantAreaRepoProc tenantAreaRepoProc;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;
    @Autowired
    private TenantClientProvider tenantClientProvider;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private SysCacheAreaRpcService cacheAreaRpcService;
    private static final String CACHE_TREE_COMMON = "cloudt:sysAreaTreeMap";
    private static final String CACHE_ITEM_ALL_DTO = "allDto";
    private static final String CACHE_ITEM_ALL_VO = "allVo";
    private static final String CACHE_ITEM_CN_VO = "CnVo";

    public AreaBO getAreaBO(String provinceCode, String cityCode, String countyCode) {
        ArrayList<String> codes = new ArrayList<String>(8);
        if (CharSequenceUtil.isNotBlank((CharSequence)provinceCode)) {
            codes.add(provinceCode);
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)cityCode)) {
            codes.add(cityCode);
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)countyCode)) {
            codes.add(countyCode);
        }
        if (codes.isEmpty()) {
            return null;
        }
        Map<String, String> codeNameMap = this.repoProc.getCodeAndName(codes);
        AreaBO areaBO = new AreaBO();
        areaBO.setProvinceCode(provinceCode);
        if (CharSequenceUtil.isNotBlank((CharSequence)provinceCode)) {
            areaBO.setProvinceName(codeNameMap.get(provinceCode));
        }
        areaBO.setCityCode(cityCode);
        if (CharSequenceUtil.isNotBlank((CharSequence)cityCode)) {
            areaBO.setCityName(codeNameMap.get(cityCode));
        }
        areaBO.setCountyCode(countyCode);
        if (CharSequenceUtil.isNotBlank((CharSequence)countyCode)) {
            areaBO.setCountyName(codeNameMap.get(countyCode));
        }
        return areaBO;
    }

    public void clearCache() {
        this.redisUtils.hdel(CACHE_TREE_COMMON);
        this.cacheAreaRpcService.clearCacheForAllTenant();
    }

    public List<SysAreaRespDTO> allTree(boolean tree) {
        List dataTree = (List)this.redisUtils.hget(CACHE_TREE_COMMON, CACHE_ITEM_ALL_DTO);
        if (dataTree != null) {
            if (!tree) {
                dataTree = CollectionUtil.expandTree(dataTree, SysAreaRespDTO::getChildren);
            }
            return dataTree;
        }
        dataTree = this.queryAreaTree();
        this.redisUtils.hset(CACHE_TREE_COMMON, CACHE_ITEM_ALL_DTO, (Object)dataTree);
        if (tree) {
            return dataTree;
        }
        return CollectionUtil.expandTree((List)dataTree, SysAreaRespDTO::getChildren);
    }

    public List<CommonAreaTreeRespVO> listTree(Long pid, String pcode, boolean tree) {
        List respVoList = null;
        if (pid == null && CharSequenceUtil.isBlank((CharSequence)pcode)) {
            respVoList = (List)this.redisUtils.hget(CACHE_TREE_COMMON, CACHE_ITEM_ALL_VO);
            if (respVoList != null) {
                return tree ? respVoList : CollectionUtil.expandTree((List)respVoList, TreeRespParam::getChildren);
            }
            respVoList = this.queryAreaTree(null, null);
            this.redisUtils.hset(CACHE_TREE_COMMON, CACHE_ITEM_ALL_VO, respVoList);
            return tree ? respVoList : CollectionUtil.expandTree(respVoList, TreeRespParam::getChildren);
        }
        boolean isCn = "CN".equals(pcode);
        if (!isCn && pid != null) {
            String tempCode = this.repoProc.getCode(pid);
            isCn = "CN".equals(tempCode);
        }
        if (isCn) {
            respVoList = (List)this.redisUtils.hget(CACHE_TREE_COMMON, CACHE_ITEM_CN_VO);
            if (respVoList != null) {
                return tree ? respVoList : CollectionUtil.expandTree((List)respVoList, TreeRespParam::getChildren);
            }
            respVoList = this.queryAreaTree(pid, pcode);
            if (respVoList.size() == 1 && "CN".equals(((CommonAreaTreeRespVO)((Object)respVoList.get(0))).getCode())) {
                respVoList = ((CommonAreaTreeRespVO)((Object)respVoList.get(0))).getChildren();
            }
            this.redisUtils.hset(CACHE_TREE_COMMON, CACHE_ITEM_CN_VO, (Object)respVoList);
            return tree ? respVoList : CollectionUtil.expandTree((List)respVoList, TreeRespParam::getChildren);
        }
        respVoList = this.queryAreaTree(pid, pcode);
        return tree ? respVoList : CollectionUtil.expandTree(respVoList, TreeRespParam::getChildren);
    }

    public <T> T areaTemplate(Supplier<T> supplier) {
        boolean enabled = this.enabledPlatform();
        return (T)(enabled ? this.tenantDataIsolateProvider.byDefaultDirectly(supplier) : supplier.get());
    }

    private List<SysAreaRespDTO> queryAreaTree() {
        List dtoList = this.areaTemplate(() -> this.repoProc.all()).stream().filter(t -> Boolean.TRUE.equals(t.getEnabled())).map(t -> {
            SysAreaRespDTO dto = AreaConvert.INSTANCE.do2DTO((SysPlatformAreaDO)((Object)t));
            if (dto.getSortNo() == null) {
                dto.setSortNo(Integer.valueOf(0));
            }
            return dto;
        }).collect(Collectors.toList());
        if (dtoList.isEmpty()) {
            return Collections.emptyList();
        }
        TreeDataUtil treeDataUtil = new TreeDataUtil(dtoList, SysAreaRespDTO::getAreaCode, SysAreaRespDTO::getParentAreaCode, SysAreaRespDTO::setChildren, Comparator.comparingInt(SysAreaRespDTO::getSortNo));
        return treeDataUtil.getRoots();
    }

    private List<CommonAreaTreeRespVO> queryAreaTree(Long pid, String pcode) {
        List<CommonAreaTreeRespVO> respVoList = this.repoProc.queryList(pcode, pid);
        if (respVoList.isEmpty()) {
            return respVoList;
        }
        TreeDataUtil treeDataUtil = new TreeDataUtil(respVoList, TreeRespParam::getCode, TreeRespParam::getParentCode, TreeRespParam::setChildren, Comparator.comparingInt(TreeRespParam::getSortNo));
        return treeDataUtil.getRoots();
    }

    private boolean enabledPlatform() {
        SysTenantDTO tenant = this.tenantClientProvider.getCurrentTenant();
        Long tenantId = tenant == null ? TenantConstant.DEFAULT_TENANT_ID : tenant.getId();
        Boolean enabled = this.tenantAreaRepoProc.getEnabled(tenantId);
        return enabled == null || enabled != false;
    }
}

