/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.model.entity;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.annotation.BusinessParam;
import com.elitescloud.boot.constant.Gender;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import java.time.LocalDate;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.springframework.util.StringUtils;

@Entity
@Table(name="sys_user", indexes={@Index(name="idx_sys_user_username", columnList="username", unique=true), @Index(name="idx_sys_user_mobile", columnList="mobile"), @Index(name="idx_sys_user_email", columnList="email"), @Index(name="idx_sys_user_source", columnList="sourceType"), @Index(name="idx_sys_user_cas_user", columnList="casUserId")})
@Comment(value="\u7cfb\u7edf\u7528\u6237\u8d26\u53f7")
@DynamicUpdate
@DynamicInsert
public class SysUserDO
extends BaseModel {
    private static final long serialVersionUID = -7840804475330315230L;
    @Comment(value="\u767b\u5f55\u8d26\u53f7")
    @Column(nullable=false)
    @BusinessParam(dataPermissionEnabled=false, fieldPermissionEnabled=true)
    private String username;
    @Comment(value="\u767b\u5f55\u5bc6\u7801")
    @Column(nullable=false)
    private String password;
    @Comment(value="\u5bc6\u7801\u662f\u5426\u9700\u8981\u91cd\u65b0\u8bbe\u7f6e", defaultValue="1")
    @Column
    private Boolean needReset;
    @Comment(value="\u59d3\u540d-\u59d3\u6c0f")
    @Column
    private String lastName;
    @Comment(value="\u59d3\u540d-\u540d\u5b57")
    @Column
    private String firstName;
    @Column
    @Comment(value="\u6027\u522b\uff0c\uff08male-\u7537\uff0cfemale-\u5973\uff0csecret-\u4fdd\u5bc6\uff09")
    private String gender;
    @Column
    @Comment(value="\u6635\u79f0")
    private String nickName;
    @Column
    @Comment(value="\u751f\u65e5")
    private LocalDate birthDate;
    @Comment(value="\u624b\u673a\u53f7")
    @Column
    private String mobile;
    @Comment(value="\u90ae\u7bb1")
    @Column
    private String email;
    @Comment(value="\u662f\u5426\u542f\u7528", defaultValue="1")
    @Column
    @BusinessParam(dataPermissionEnabled=true, fieldPermissionEnabled=true)
    private Boolean enabled;
    @Comment(value="\u4e0a\u6b21\u767b\u5f55\u65f6\u95f4")
    @Column
    private LocalDateTime lastLoginTime;
    @Comment(value="\u5bc6\u7801\u8fc7\u671f\u65f6\u95f4")
    @Column
    private LocalDateTime passwordExpiredTime;
    @Comment(value="\u8d26\u53f7\u8fc7\u671f\u65f6\u95f4")
    @Column
    private LocalDateTime expiredTime;
    @Column
    @Comment(value="\u8eab\u4efd\u8bc1\u53f7")
    private String idCard;
    @Column
    @Comment(value="\u56fd\u5bb6\u7f16\u7801")
    private String countryCode;
    @Column
    @Comment(value="\u7701\u7f16\u7801")
    private String provinceCode;
    @Column
    @Comment(value="\u5e02\u7f16\u7801")
    private String cityCode;
    @Column
    @Comment(value="\u53bf\u7f16\u7801")
    private String countyCode;
    @Column
    @Comment(value="\u8be6\u7ec6\u5730\u5740")
    private String address;
    @Column
    @Comment(value="\u4e2a\u6027\u7b7e\u540d")
    private String personalSign;
    @Comment(value="\u8d26\u53f7\u6765\u6e90, sys\uff1a \u7cfb\u7edf\u521b\u5efa\uff1bwec\uff1a\u5fae\u4fe1\u521b\u5efa\uff1both\uff1a\u5176\u4ed6\u65b9\u5f0f")
    @Column
    private String sourceType;
    @Comment(value="\u7528\u6237\u5934\u50cf\u5730\u5740\uff0c\u53ef\u76f4\u63a5\u8bbf\u95ee\uff0c\u5982\u5fae\u4fe1\u5934\u50cf\u5730\u5740\u7b49")
    @Lob
    private String avatarUrl;
    @Comment(value="\u7528\u6237\u5934\u50cf\u5728\u6587\u4ef6\u670d\u52a1\u5668\u4e2d\u7684\u6807\u8bc6")
    @Column
    private String avatarCode;
    @Comment(value="\u662f\u5426\u9700\u8981\u5411\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u4e2d\u5fc3\u540c\u6b65", defaultValue="1")
    @Column
    private Boolean syncCas;
    @Comment(value="\u5728\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u4e2d\u5fc3\u7684ID")
    @Column
    private Long casUserId;

    public String getFullName() {
        if (!StringUtils.hasText((String)this.lastName)) {
            return this.firstName;
        }
        return this.lastName + CharSequenceUtil.blankToDefault((CharSequence)this.firstName, (String)"");
    }

    public String getGenderName() {
        if (CharSequenceUtil.isBlank((CharSequence)this.getGender())) {
            return null;
        }
        return new Gender(this.getGender()).getDescription();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SysUserDO) {
            SysUserDO the = (SysUserDO)((Object)obj);
            if (this.getId() == null) {
                return the.getId() == null;
            }
            return this.getId().equals(the.getId());
        }
        return false;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Boolean getNeedReset() {
        return this.needReset;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getGender() {
        return this.gender;
    }

    public String getNickName() {
        return this.nickName;
    }

    public LocalDate getBirthDate() {
        return this.birthDate;
    }

    public String getMobile() {
        return this.mobile;
    }

    public String getEmail() {
        return this.email;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public LocalDateTime getLastLoginTime() {
        return this.lastLoginTime;
    }

    public LocalDateTime getPasswordExpiredTime() {
        return this.passwordExpiredTime;
    }

    public LocalDateTime getExpiredTime() {
        return this.expiredTime;
    }

    public String getIdCard() {
        return this.idCard;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getProvinceCode() {
        return this.provinceCode;
    }

    public String getCityCode() {
        return this.cityCode;
    }

    public String getCountyCode() {
        return this.countyCode;
    }

    public String getAddress() {
        return this.address;
    }

    public String getPersonalSign() {
        return this.personalSign;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public String getAvatarCode() {
        return this.avatarCode;
    }

    public Boolean getSyncCas() {
        return this.syncCas;
    }

    public Long getCasUserId() {
        return this.casUserId;
    }

    public SysUserDO setUsername(String username) {
        this.username = username;
        return this;
    }

    public SysUserDO setPassword(String password) {
        this.password = password;
        return this;
    }

    public SysUserDO setNeedReset(Boolean needReset) {
        this.needReset = needReset;
        return this;
    }

    public SysUserDO setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public SysUserDO setFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public SysUserDO setGender(String gender) {
        this.gender = gender;
        return this;
    }

    public SysUserDO setNickName(String nickName) {
        this.nickName = nickName;
        return this;
    }

    public SysUserDO setBirthDate(LocalDate birthDate) {
        this.birthDate = birthDate;
        return this;
    }

    public SysUserDO setMobile(String mobile) {
        this.mobile = mobile;
        return this;
    }

    public SysUserDO setEmail(String email) {
        this.email = email;
        return this;
    }

    public SysUserDO setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public SysUserDO setLastLoginTime(LocalDateTime lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
        return this;
    }

    public SysUserDO setPasswordExpiredTime(LocalDateTime passwordExpiredTime) {
        this.passwordExpiredTime = passwordExpiredTime;
        return this;
    }

    public SysUserDO setExpiredTime(LocalDateTime expiredTime) {
        this.expiredTime = expiredTime;
        return this;
    }

    public SysUserDO setIdCard(String idCard) {
        this.idCard = idCard;
        return this;
    }

    public SysUserDO setCountryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    public SysUserDO setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
        return this;
    }

    public SysUserDO setCityCode(String cityCode) {
        this.cityCode = cityCode;
        return this;
    }

    public SysUserDO setCountyCode(String countyCode) {
        this.countyCode = countyCode;
        return this;
    }

    public SysUserDO setAddress(String address) {
        this.address = address;
        return this;
    }

    public SysUserDO setPersonalSign(String personalSign) {
        this.personalSign = personalSign;
        return this;
    }

    public SysUserDO setSourceType(String sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    public SysUserDO setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
        return this;
    }

    public SysUserDO setAvatarCode(String avatarCode) {
        this.avatarCode = avatarCode;
        return this;
    }

    public SysUserDO setSyncCas(Boolean syncCas) {
        this.syncCas = syncCas;
        return this;
    }

    public SysUserDO setCasUserId(Long casUserId) {
        this.casUserId = casUserId;
        return this;
    }
}

