package com.elitescloud.cloudt.system.service.callback;

import com.elitescloud.cloudt.system.service.model.bo.SysEmployeeSaveBO;
import com.elitescloud.cloudt.system.service.model.entity.SysEmployeeDO;

/**
 * 员工信息变化后的回调.
 *
 * @author Kaiser（wang shao）
 * 2022/10/9
 */
public interface EmployeeChangedCallback {

    /**
     * 员工保存后的回调
     *
     * @param add        是否新增
     * @param saveBO     保存信息
     * @param employeeDO 员工信息
     */
    void onUpsert(boolean add, SysEmployeeSaveBO saveBO, SysEmployeeDO employeeDO);

    /**
     * 启用状态变化后的回调
     *
     * @param employeeId 员工ID
     * @param enabled    是否是启用
     */
    void onEnabled(Long employeeId, boolean enabled);

    /**
     * 删除后的回调
     *
     * @param employeeId 员工ID
     */
    void onDelete(Long employeeId);
}
