package com.elitescloud.cloudt.system.service.common.constant;

import com.elitescloud.boot.common.annotation.businessobject.OperationStateEnum;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 参数位置.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/8
 */
public enum BusinessObjectParamInEnum {
    /**
     * 普通的位置
     * <p>
     * 取值：{@link com.elitescloud.boot.swagger.openapi.swagger3.annotations.enums.ParameterIn}
     */
    DEFAULT(""),
    HEADER("header"),
    QUERY("query"),
    PATH("path"),
    COOKIE("cookie"),
    // 自定义参数
    REQUEST_BODY("requestBody"),
    RESPONSE_BODY("responseBody"),
    ;

    private final String value;

    private BusinessObjectParamInEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    private static final Map<String, BusinessObjectParamInEnum> VALUE_MAP = Arrays.stream(BusinessObjectParamInEnum.values()).collect(Collectors.toMap(BusinessObjectParamInEnum::getValue, t -> t, (t1, t2) -> t1));

    public static BusinessObjectParamInEnum parse(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.get(value);
    }
}
