package com.elitescloud.cloudt.system.service.model.bo;

import com.elitescloud.boot.datasecurity.dpr.content.DprSysInternallyEnum;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

/**
 * 数据权限保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 3/29/2023
 */
@Data
public class SysDprSaveBO {

    /**
     * 角色ID
     */
    @NotNull
    private Long roleId;

    /**
     * 菜单编码
     */
    @NotBlank
    private String menuCode;

    /**
     * 接口编码
     */
    @NotBlank
    private String apiCode;

    /**
     * 数据范围
     */
    private DprSysInternallyEnum range;

    /**
     * 自定义规则列表
     */
    private List<SysDprApiCustomRuleSaveBO> customRuleList = new ArrayList<>(0);

    /**
     * 字段权限列表
     */
    private List<SysDprApiFieldSaveBO> fieldList = new ArrayList<>(0);
}
