package com.elitescloud.cloudt.system.service.model.bo;

import com.elitescloud.cloudt.system.constant.UserSourceType;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Set;

/**
 * 用户保存信息.
 *
 * @author Kaiser（wang shao）
 * 2022/9/23
 */
@Data
public class SysUserSaveBO {

    /**
     * 用户ID
     */
    private Long id;

    /**
     * 登录账号
     */
    private String username;

    /**
     * 外部唯一标识
     */
    private String outerKey;

    /**
     * 登录密码
     */
    private String password;

    /**
     * 密码是否需要重新设置
     */
    private Boolean needReset;

    /**
     * 姓名
     */
    private String fullName;

    /**
     * 性别
     */
    private String gender;

    /**
     * 昵称
     */
    private String nickName;

    /**
     * 生日
     */
    private LocalDate birthDate;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 个人邮箱
     */
    private String email;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 账号过期时间
     */
    private LocalDateTime expiredTime;

    /**
     * 身份证号
     */
    private String idCard;

    /**
     * 所在地-省份
     */
    private AreaBO areaBO;

    /**
     * 地址
     */
    private String address;

    /**
     * 个性签名
     */
    private String personalSign;

    /**
     * 账号来源
     * {@link UserSourceType}
     */
    private String sourceType;

    /**
     * 用户头像地址，可直接访问
     */
    private String avatarUrl;

    /**
     * 用户头像在文件服务器中的标识
     */
    private String avatarCode;

    /**
     * 备注
     */
    private String remark;

    /**
     * 终端
     */
    private Set<String> terminals;

    /**
     * 终端
     */
    private Set<String> terminalsAdd;

    /**
     * 用户类型
     */
    private Set<SysUserTypeBO> userTypes;

    /**
     * 新增的用户类型
     */
    private Set<SysUserTypeBO> userTypesAdd;

    /**
     * 扩展参数
     */
    private Object extend;
}
