package com.elitescloud.cloudt.system.service.model.bo;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 账号类型.
 *
 * @author Kaiser（wang shao）
 * @date 2023/12/26
 */
@Data
public class SysUserTypeBO implements Serializable {
    private static final long serialVersionUID = -1048540955533358321L;

    /**
     * 账号类型
     * <p>
     * {@link com.elitescloud.cloudt.system.constant.UserType}
     */
    @NotBlank(message = "账号类型不能为空")
    private String userType;

    /**
     * 身份标识ID
     */
    private String identityId;

    public SysUserTypeBO() {
    }

    public SysUserTypeBO(String userType) {
        this.userType = userType;
    }

    public SysUserTypeBO(String userType, String identityId) {
        this.userType = userType;
        this.identityId = identityId;
    }
}
