package com.elitescloud.cloudt.system.service.model.entity;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.annotation.BusinessParam;
import com.elitescloud.boot.constant.Gender;
import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModel;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.constant.BusinessObjectConstant;
import com.elitescloud.cloudt.system.constant.EmployeeType;
//import com.elitescloud.cloudt.system.service.JsonStringType;
import com.elitescloud.cloudt.system.service.common.constant.TableNameConstant;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicUpdate;
//import org.hibernate.annotations.Type;
//import org.hibernate.annotations.TypeDef;
import org.springframework.util.StringUtils;

import javax.persistence.*;
import java.time.LocalDate;
import java.time.LocalDateTime;
//import java.util.Map;

/**
 * 员工.
 * <p>
 * 与组织关联的用户实体称之为员工
 *
 * @author Kaiser（wang shao）
 * 2022/9/16
 */
@Entity
@Table(name = TableNameConstant.SYS_EMPLOYEE, indexes = {
        @Index(name = "idx_sys_emp_user_id", columnList = "userId"),
        @Index(name = "idx_sys_emp_root_org_id", columnList = "rootOrgId"),
        @Index(name = "idx_sys_emp_code", columnList = "code"),
        @Index(name = "idx_sys_emp_type", columnList = "type"),
        @Index(name = "idx_sys_emp_email", columnList = "email"),
})
@Comment("员工")
@Getter
@Setter
@DynamicUpdate
//@TypeDef(name = "json", typeClass = JsonStringType.class)
public class SysEmployeeDO extends CustomFieldBaseModel {
    private static final long serialVersionUID = 3344534498352255891L;

    @BusinessParam(relatedBusinessObject = BusinessObjectConstant.SYS_USER, dataPermissionEnabled = true, fieldPermissionEnabled = false)
    @Column(nullable = false)
    @Comment("用户账号ID")
    private Long userId;

    @BusinessParam(relatedBusinessObject = BusinessObjectConstant.SYS_ORG, dataPermissionEnabled = true, fieldPermissionEnabled = false)
    @Column(nullable = false)
    @Comment("根组织ID")
    private Long rootOrgId;

    @BusinessParam(relatedBusinessObject = BusinessObjectConstant.SYS_USER, relatedField = "username", dataPermissionEnabled = true, fieldPermissionEnabled = false)
    @Comment("用户账号")
    @Column()
    private String username;

    @Comment("姓名-姓氏")
    @Column()
    private String lastName;

    @Comment("姓名-名字")
    @Column()
    private String firstName;

    /**
     * 取值：{@link com.elitescloud.boot.constant.Gender}
     */
    @Column()
    @Comment("性别，（male-男，female-女，secret-保密）")
    private String gender;

    @Column()
    @Comment("昵称")
    private String nickName;

    @Column()
    @Comment("生日")
    private LocalDate birthDate;

    @Column()
    @Comment("员工编号")
    @BusinessParam(dataPermissionEnabled = false, fieldPermissionEnabled = true)
    private String code;

    /**
     * UDC：{@link com.elitescloud.cloudt.system.constant.EmployeeType}
     */
    @BusinessParam(relatedBusinessObject = BusinessObjectConstant.SYS_PLATFORM_UDC, relatedField = "udcValueCode",
            values = {Application.NAME, EmployeeType.UDC_CODE})
    @Column()
    @Comment("员工类型，[UDC]cloudt-system:employeeType")
    private String type;

    @Column()
    @Comment("职务")
    private String duty;

    @Column()
    @Comment("员工照片")
    private String photo;

    @Column()
    @Comment("合同起始时间")
    private LocalDateTime contractStartTime;

    @Column()
    @Comment("合同截止时间")
    private LocalDateTime contractEndTime;

    @Column()
    @Comment("入职时间")
    private LocalDateTime joinTime;

    @Comment("办公电话")
    @Column()
    private String phone;

    @Comment("工作邮箱")
    @Column()
    private String emailWork;

    @Comment("手机号")
    @Column()
    private String mobile;

    @Comment("个人邮箱")
    @Column()
    private String email;

    @Column()
    @Comment("身份证号")
    private String idCard;

    @Column()
    @Comment("离职时间")
    private LocalDateTime leaveTime;

    @Column()
    @Comment(value = "是否在职", defaultValue = "1")
    @BusinessParam(dataPermissionEnabled = true, fieldPermissionEnabled = true)
    private Boolean served;

    @Column()
    @Comment(value = "是否启用", defaultValue = "1")
    @BusinessParam(dataPermissionEnabled = true, fieldPermissionEnabled = true)
    private Boolean enabled;

    @Column()
    @Comment(value = "顺序", defaultValue = "1")
    private Integer sortNo;

    @Column()
    @Comment("国家编码")
    private String countryCode;

    @Column()
    @Comment("省编码")
    private String provinceCode;

    @Column()
    @Comment("市编码")
    private String cityCode;

    @Column()
    @Comment("县编码")
    private String countyCode;

    @Column()
    @Comment("详细地址")
    private String address;

    @Column()
    @Comment("个性签名")
    private String personalSign;

    @Comment("用户头像地址，可直接访问，如微信头像地址等")
    @Lob
    private String avatarUrl;

    @Comment("用户头像在文件服务器中的标识")
    @Column()
    private String avatarCode;

//    @Type(type = "json")
//    @Column()
//    @Comment(value = "自定义json字段")
//    private Map<String, String> customFields;

    /**
     * 获取全名
     *
     * @return 全名
     */
    public String getFullName() {
        if (!StringUtils.hasText(lastName)) {
            return firstName;
        }

        return lastName + CharSequenceUtil.blankToDefault(firstName, "");
    }

    /**
     * 获取性别
     *
     * @return 性别
     */
    public String getGenderName() {
        if (CharSequenceUtil.isBlank(getGender())) {
            return null;
        }
        return new Gender(getGender()).getDescription();
    }

    @Override
    public int hashCode() {
        return getId().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SysEmployeeDO) {
            SysEmployeeDO the = (SysEmployeeDO) obj;
            if (getId() == null) {
                return the.getId() == null;
            }
            return getId().equals(the.getId());
        }
        return false;
    }
}
