package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.service.common.constant.TableNameConstant;
import com.elitescloud.cloudt.system.service.model.BaseStdModel;
import io.swagger.annotations.ApiModel;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;
import org.hibernate.Hibernate;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import java.util.Objects;

/**
 * 平台应用管理
 *
 * @author niu.chen
 * @date: 2022.09.15
 */
@Entity

@org.hibernate.annotations.Table(appliesTo = TableNameConstant.SYS_PLATFORM_APP, comment = "平台应用管理")
@Getter
@Setter
@ToString
@RequiredArgsConstructor
@DynamicInsert
@DynamicUpdate
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
@ApiModel(value = TableNameConstant.SYS_PLATFORM_APP, description = "平台应用管理")
@Table(name = TableNameConstant.SYS_PLATFORM_APP, uniqueConstraints = @UniqueConstraint(columnNames = {"appCode"}))
public class SysPlatformAppDO extends BaseStdModel {
    private static final long serialVersionUID = -3796227163209095818L;

    @Comment("应用编码")
    @Column
    private String appCode;

    @Comment("应用名称")
    @Column
    private String appName;

    /**
     * 取值：{@link com.elitescloud.cloudt.system.service.common.constant.PlatformAppTypeEnum}
     */
    @Comment("应用类型")
    @Column
    private String appType;

    @Comment(value = "应用图标")
    @Column()
    private String icon;

    @Comment("描述")
    @Column
    private String appDescribe;

    @Comment(value = "状态", defaultValue = "1")
    @Column()
    private Boolean appState;

    @Comment(value = "排序", defaultValue = "1")
    @Column()
    private Integer appOrder;

    @Comment(value = "是否外部应用", defaultValue = "0")
    @Column()
    private Boolean outerApp;

    /**
     * 取值：{@link com.elitescloud.cloudt.system.service.common.constant.AppAuthTypeEnum}
     */
    @Comment(value = "授权类型", defaultValue = "'AUTHED'")
    @Column()
    private String authType;

    @Comment(value = "外部应用访问地址")
    @Column()
    private String url;

    @Comment(value = "外部应用生成token地址")
    @Column()
    private String tokenUrl;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass(this) != Hibernate.getClass(o)) {
            return false;
        }
        SysPlatformAppDO that = (SysPlatformAppDO) o;
        return getId() != null && Objects.equals(getId(), that.getId());
    }

    @Override
    public int hashCode() {
        return getClass().hashCode();
    }
}
