package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.datasecurity.dpr.content.DprRuleConditionEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleRelationEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleValueTypeEnum;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.constant.DataPermissionType;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 角色与数据权限的关联.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/21
 */
@Entity
@Table(name = "sys_role_data_permission", indexes = {
        @Index(name = "idx_role_datapermission_role", columnList = "roleCode"),
        @Index(name = "idx_role_datapermission_type", columnList = "permissionType"),
        @Index(name = "idx_role_datapermission_menu", columnList = "menuCode"),
        @Index(name = "idx_role_datapermission_obj", columnList = "businessObjectCode"),
        @Index(name = "idx_role_datapermission_opera", columnList = "operationCode"),
})
@Comment("角色与数据权限的关联")
@DynamicInsert
@Getter
@Setter
public class SysRoleDataPermissionDO extends BaseModel {
    private static final long serialVersionUID = 631994642513754087L;

    @Column(nullable = false)
    @Comment("角色编码")
    private String roleCode;

    /**
     * {@link DataPermissionType}
     */
    @Column(nullable = false)
    @Comment("权限类型")
    private String permissionType;

    @Column()
    @Comment("应用编码")
    private String appCode;

    @Column()
    @Comment("菜单编码")
    private String menuCode;

    @Column()
    @Comment("业务对象编码")
    private String businessObjectCode;

    @Column()
    @Comment("操作编码")
    private String operationCode;

    @Column()
    @Comment("规则组编码")
    private String ruleGroupCode;

    /**
     * 取值：{@link DprRuleRelationEnum}
     */
    @Column()
    @Comment("规则关系")
    private String ruleRelation;

    @Column()
    @Comment("规则名称")
    private String ruleName;

    @Column()
    @Comment(value = "规则排序", defaultValue = "0")
    private Integer ruleOrder;

    @Column()
    @Comment("规则描述")
    private String ruleDescription;

    @Column()
    @Comment("规则字段")
    private String ruleField;

    @Column()
    @Comment("规则字段类型")
    private String ruleFieldType;

    @Column()
    @Comment(value = "是否引用资源配置", defaultValue = "0")
    private Boolean refResource;

    @Column()
    @Comment("引用的业务对象编码")
    private String refBusinessObject;

    @Column()
    @Comment("引用的业务对象字段")
    private String refField;

    /**
     * 取值，{@link DprRuleConditionEnum}
     */
    @Column()
    @Comment("字段与值的关系")
    private String fieldValueCondition;

    /**
     * 取值，{@link DprRuleValueTypeEnum}
     */
    @Column()
    @Comment("值类型")
    private String ruleValueType;

    @Column()
    @Comment("规则值")
    private String ruleValue;

    @Column()
    @Comment("规则值名称")
    private String ruleValueName;

    @Column()
    @Comment("数据集类型")
    private String dataSet;

    @Column()
    @Comment("特用字段1")
    private String bs1;

    @Column()
    @Comment("特用字段2")
    private String bs2;

    @Column()
    @Comment("特用字段3")
    private String bs3;
}
