package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Objects;

/**
 * 租户菜单.
 * <p>
 * 租户自定义菜单树
 *
 * @author Kaiser（wang shao）
 * 2022/10/13
 */
@Entity
@Table(name = "sys_tenant_menu", indexes = {
        @Index(name = "idx_sys_tenant_menu_tenant", columnList = "sysTenantId", unique = true),
})
@Comment("员工")
@Getter
@Setter
public class SysTenantMenuDO extends BaseModel {
    private static final long serialVersionUID = 6124307986597380438L;

    @Column(nullable = false)
    @Comment("租户ID")
    private Long sysTenantId;

    @Column(nullable = false)
    @Comment(value = "是否启用自定义菜单树", defaultValue = "0")
    private Boolean enabled;

    @Override
    public int hashCode() {
        return Objects.hashCode(getId());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SysTenantMenuDO) {
            SysTenantMenuDO the = (SysTenantMenuDO) obj;
            if (getId() == null) {
                return the.getId() == null;
            }
            return getId().equals(the.getId());
        }
        return false;
    }
}
