package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.constant.SysThirdPartyAccountBusinessType;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.*;
import java.util.Objects;

/**
 * 第三方账号.
 *
 * @author Kaiser（wang shao）
 * @date 2/10/2023
 */
@Entity
@Table(name = "sys_third_party_account", indexes = {
        @Index(name = "idx_third_part_tenant", columnList = "sysTenantId"),
        @Index(name = "idx_third_part_account", columnList = "account", unique = true),
        @Index(name = "idx_third_part_account_t", columnList = "accountType"),
})
@Comment("第三方账号")
@DynamicInsert
@Getter
@Setter
public class SysThirdPartyAccountDO extends BaseModel {
    private static final long serialVersionUID = 2512548121104875648L;

    @Column(nullable = false)
    @Comment("租户ID")
    private Long sysTenantId;

    /**
     * {@link SysThirdPartyAccountBusinessType}
     */
    @Column()
    @Comment("业务类型，[UDC]cloudt-system:thirdPartyAccountBusinessType")
    private String businessType;

    /**
     * 账号名称
     */
    @Column(nullable = false)
    @Comment("账号名称")
    private String name;

    /**
     * 账号
     */
    @Column(nullable = false)
    @Comment("账号")
    private String account;

    /**
     * 账号类型
     * {@link com.elitescloud.cloudt.system.service.common.constant.ThirdPartAccountType}
     */
    @Column(nullable = false)
    @Comment("账号类型")
    private String accountType;

    /**
     * 是否启用
     */
    @Column()
    @Comment(value = "是否启用", defaultValue = "1")
    private Boolean enabled;

    /**
     * json格式的配置内容
     */
    @Column()
    @Comment(value = "json格式的配置内容")
    @Lob
    private String configJson;

    @Column()
    @Comment("统一认证中心的ID")
    private Long casId;

    @Override
    public int hashCode() {
        return Objects.hashCode(getId());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SysThirdPartyAccountDO) {
            SysThirdPartyAccountDO the = (SysThirdPartyAccountDO) obj;
            if (getId() == null) {
                return the.getId() == null;
            }
            return getId().equals(the.getId());
        }
        return false;
    }
}
