package com.elitescloud.cloudt.system.service.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;


/**
 * @author Chris
 * 2021-07-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class SysUserPagingParam extends AbstractOrderQueryParam implements Serializable {

    private static final long serialVersionUID = 4853804600617527927L;

    @ApiModelProperty("用户账号")
    private String username;

    @ApiModelProperty("用户姓名")
    private String name;

    @ApiModelProperty("手机号")
    private String mobile;

    @ApiModelProperty("电子邮箱")
    private String email;

    @ApiModelProperty("所属租户ID")
    private Long tenantId;

    @ApiModelProperty("所属租户名称")
    private String tenantName;

    @ApiModelProperty("账号是否启用")
    private Boolean enabled;

    @ApiModelProperty("应用角色名称或编号，支持模糊查询")
    private String roleCodeName;

    @ApiModelProperty("数据角色名称或编号，支持模糊查询")
    private String dataRoleCodeName;

    @ApiModelProperty("流程角色名称或编号，支持模糊查询")
    private String flowRoleCodeName;

    @ApiModelProperty("公司名称，支持模糊查询")
    private String ouName;
}
