package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.service.model.entity.QSysTenantDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysTenantUserDO;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantDO;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantUserDO;
import com.elitescloud.cloudt.system.service.model.vo.SysUserTenantVO;
import com.querydsl.core.types.Projections;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/3/23
 */
@Repository
public class SysTenantUserRepoProc extends BaseRepoProc<SysTenantUserDO> {

    private static final QSysTenantUserDO QDO = QSysTenantUserDO.sysTenantUserDO;
    private static final QSysTenantDO QDO_TENANT = QSysTenantDO.sysTenantDO;

    public SysTenantUserRepoProc() {
        super(QDO);
    }

    /**
     * 根据租住删除
     *
     * @param tenantId 租户ID
     */
    public void deleteByTenant(long tenantId) {
        super.deleteByValue(QDO.sysTenantId, tenantId);
    }

    /**
     * 解绑租户与用户关系
     *
     * @param tenantId
     * @param userId
     */
    public void unbindTenant(long tenantId, long userId) {
        jpaQueryFactory.delete(QDO)
                .where(QDO.sysUserId.eq(userId).and(QDO.sysTenantId.eq(tenantId)))
                .execute();
    }

    /**
     * 更新启用状态
     *
     * @param tenantId
     * @param userId
     * @param enabled
     */
    public void updateEnabled(Long tenantId, Long userId, Boolean enabled) {
        jpaQueryFactory.update(QDO)
                .set(QDO.enabled, enabled)
                .where(QDO.sysUserId.eq(userId).and(QDO.sysTenantId.eq(tenantId)))
                .execute();
    }

    /**
     * 获取用户租户关联
     *
     * @param tenantId 租户ID
     * @param userId   用户ID
     * @return 关联
     */
    public SysTenantUserDO get(Long tenantId, Long userId) {
        return jpaQueryFactory.select(QDO)
                .from(QDO)
                .where(QDO.sysUserId.eq(userId).and(QDO.sysTenantId.eq(tenantId)))
                .limit(1)
                .fetchOne();
    }

    /**
     * 获取用户的租户ID
     *
     * @param userId
     * @return
     */
    public List<Long> getTenantIdOfUser(Long userId) {
        return jpaQueryFactory.select(QDO.sysTenantId)
                .from(QDO)
                .where(QDO.sysUserId.eq(userId))
                .fetch();
    }

    /**
     * 查询用户绑定的租户详细信息
     *
     * @param userId 用户ID
     * @return
     */
    public List<SysTenantDO> queryUserTenantDetail(Long userId) {
        return jpaQueryFactory.select(QDO_TENANT)
                .from(QDO).leftJoin(QDO_TENANT).on(QDO_TENANT.id.eq(QDO.sysTenantId))
                .where(QDO.sysUserId.eq(userId).and(QDO_TENANT.deleteFlag.eq(0)).and(QDO.enabled.eq(true)))
                .orderBy(QDO.lastLoginTime.desc())
                .fetch();

    }

    /**
     * 获取用户绑定的租户信息
     *
     * @param userId 用户ID
     * @return
     */
    public List<SysUserTenantVO> queryUserTenant(Long userId) {
        return jpaQueryFactory.select(Projections.bean(SysUserTenantVO.class,
                                QDO.sysUserId, QDO.sysTenantId, QDO.bindTime,
                                QDO_TENANT.tenantCode, QDO_TENANT.tenantName, QDO_TENANT.tenantDomain, QDO_TENANT.customDomain
                        )
                ).from(QDO)
                .leftJoin(QDO_TENANT).on(QDO_TENANT.id.eq(QDO.sysTenantId))
                .where(QDO.sysUserId.eq(userId).and(QDO_TENANT.enabled.eq(true)))
                .fetch();
    }
}
