package com.elitescloud.cloudt.system.service.vo.component;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Chris
 * 2021-06-02
 */
@Data
@ApiModel("用户分页VO-放大镜组件")
public class SysUserComponentPagingVO implements Serializable {

    private static final long serialVersionUID = 6148813016975812891L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录唯一ID")
    private Long id;

    @ApiModelProperty(value = "用户账号名称")
    private String username;

    @ApiModelProperty(value = "用户别称")
    private String lastName;

    @ApiModelProperty(value = "用户名称")
    private String firstName;

    @ApiModelProperty(value = "用户手机号码")
    private String mobile;

    @ApiModelProperty(value = "用户邮箱地址")
    private String email;
}
