package com.elitescloud.cloudt.system.service.callback;

/**
 * 租户信息变化回调.
 *
 * @author Kaiser（wang shao）
 * @date 2023/4/24
 */
public interface TenantChangedCallback {

    /**
     * 当保存租户时
     *
     * @param add 是否新增
     * @param id  租户ID
     */
    default void onSave(boolean add, long id) {
    }

    /**
     * 当启用状态变化时
     *
     * @param id      租户ID
     * @param enabled 启用状态
     */
    default void onEnabled(long id, boolean enabled) {
    }

    /**
     * 当删除时
     *
     * @param id   租户ID
     * @param real 是否真删除
     */
    default void onDelete(long id, boolean real) {
    }
}
