package com.elitescloud.cloudt.system.service.common.constant;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * java类型转换.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/20
 */
public enum JavaTypeEnum {
    /**
     * 字段类型
     */
    STRING("java.lang.String", "字符串", false, true, false, false, false, false, false),

    BOOLEAN("java.lang.Boolean", "布尔值", true, false, false, false, false, false, true),

    CHARACTER("java.lang.Character", "字符", true, true, false, false, false, false, false),

    BYTE("java.lang.Byte", "字节", true, false, true, true, false, false, false),

    SHORT("java.lang.Short", "整数", true, false, true, true, false, false, false),

    INTEGER("java.lang.Integer", "整数", true, false, true, true, false, false, false),

    LONG("java.lang.Long", "长整数", true, false, true, true, false, false, false),

    FLOAT("java.lang.Float", "数字", true, false, true, false, true, false, false),
    DOUBLE("java.lang.Double", "数字", true, false, true, false, true, false, false),
    BOOLEAN_PRIMITIVE("boolean", "布尔值", true, false, false, false, false, false, true),

    CHARACTER_PRIMITIVE("char", "字符", true, true, false, false, false, false, false),

    BYTE_PRIMITIVE("byte", "字节", true, false, true, true, false, false, false),

    SHORT_PRIMITIVE("short", "整数", true, false, true, true, false, false, false),

    INTEGER_PRIMITIVE("int", "整数", true, false, true, true, false, false, false),

    LONG_PRIMITIVE("lang", "长整数", true, false, true, true, false, false, false),

    FLOAT_PRIMITIVE("float", "数字", true, false, true, false, true, false, false),
    DOUBLE_PRIMITIVE("double", "数字", true, false, true, false, true, false, false),
    VOID("java.lang.Void", "空", false, false, false, false, false, false, false),
    DATE("java.util.Date", "日期时间", false, false, false, false, false, true, false),
    DATE_SQL("java.sql.Date", "日期时间", false, false, false, false, false, true, false),
    LOCAL_DATE("java.time.LocalDate", "日期", false, false, false, false, false, true, false),
    LOCAL_DATE_TIME("java.time.LocalDateTime", "日期时间", false, false, false, false, false, true, false),
    LOCAL_TIME("java.time.LocalTime", "时间", false, false, false, false, false, true, false),
    ;

    private final String javaClass;
    private final String description;
    private final boolean primitive;
    private final boolean string;
    private final boolean number;
    private final boolean integer;
    private final boolean decimal;
    private final boolean datetime;
    private final boolean booleanValue;

    JavaTypeEnum(String javaClass, String description, boolean primitive, boolean string, boolean number, boolean integer, boolean decimal, boolean datetime, boolean booleanValue) {
        this.javaClass = javaClass;
        this.description = description;
        this.primitive = primitive;
        this.string = string;
        this.number = number;
        this.integer = integer;
        this.decimal = decimal;
        this.datetime = datetime;
        this.booleanValue = booleanValue;
    }

    private static final Map<String, JavaTypeEnum> ALL = Arrays.stream(JavaTypeEnum.values()).collect(Collectors.toMap(JavaTypeEnum::getJavaClass, Function.identity(), (t1, t2) -> t1));

    /**
     * 解析
     *
     * @param javaClass class类名
     * @return 类型
     */
    public static JavaTypeEnum parse(String javaClass) {
        return ALL.get(javaClass);
    }

    public String getJavaClass() {
        return javaClass;
    }

    public String getDescription() {
        return description;
    }

    public boolean isPrimitive() {
        return primitive;
    }

    public boolean isString() {
        return string;
    }

    public boolean isNumber() {
        return number;
    }

    public boolean isInteger() {
        return integer;
    }

    public boolean isDecimal() {
        return decimal;
    }

    public boolean isDatetime() {
        return datetime;
    }

    public boolean isBooleanValue() {
        return booleanValue;
    }
}
