package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 数据关系.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/14
 */
@Entity
@Table(name = "sys_data_relation", indexes = {
        @Index(name = "idx_datarelation_code", columnList = "code", unique = true),
})
@Comment("数据关系")
@DynamicInsert
@Getter
@Setter
public class SysDataRelationDO extends BaseModel {
    private static final long serialVersionUID = -8447270504712842655L;

    @Comment(value = "关系编码")
    @Column(nullable = false)
    private String code;

    @Comment(value = "关系名称")
    @Column(nullable = false)
    private String name;

    @Comment(value = "业务对象编码")
    @Column()
    private String boCode;

    @Comment(value = "关联的业务对象编码")
    @Column()
    private String refBoCode;

    @Comment(value = "数据选择器编码")
    @Column()
    private String dataSelectorCode;

    @Comment(value = "是否启用", defaultValue = "1")
    @Column()
    private Boolean enabled;
}
