package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.*;

/**
 * 数据选择器.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/16
 */
@Entity
@Table(name = "sys_data_selector", indexes = {
        @Index(name = "idx_dataselect_group", columnList = "groupCode"),
        @Index(name = "idx_dataselect_code", columnList = "selectorCode"),
})
@Comment("数据选择器")
@DynamicInsert
@Getter
@Setter
public class SysDataSelectorDO extends BaseModel {
    private static final long serialVersionUID = 6726370574025502431L;

    @Column()
    @Comment(value = "分组编码")
    private String groupCode;

    @Comment(value = "选择器编码")
    @Column(nullable = false)
    private String selectorCode;

    @Column()
    @Comment(value = "选择器名称")
    private String selectorName;

    @Column()
    @Comment(value = "是否启用", defaultValue = "1")
    private Boolean enabled;

    @Comment(value = "是否是公共组件", defaultValue = "0")
    @Column()
    private Boolean component;

    @Comment(value = "组件编码")
    @Column()
    private String componentCode;

    @Comment(value = "数据接口API")
    @Column()
    private String dataApi;

    @Comment(value = "数据接口请求方式")
    @Column()
    private String dataApiMethod;

    @Comment(value = "数据格式")
    @Column()
    private String dataStyle;

    @Comment(value = "数据接口请求头")
    @Column()
    @Lob
    private String apiHeadersJson;

    @Comment(value = "数据接口请求体")
    @Column()
    @Lob
    private String apiReqBodyJson;

    @Comment(value = "数据接口查询参数")
    @Column()
    @Lob
    private String apiReqParamsJson;

    @Comment(value = "使用的数据字段")
    @Column()
    private String dataFieldsStr;

    @Comment(value = "值数量限制", defaultValue = "-1")
    @Column()
    private Integer valueNumLimit;

    @Comment(value = "扩展属性")
    @Column()
    @Lob
    private String extAttributesJson;
}
