package com.elitescloud.cloudt.system.service.model.entity;


import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.service.common.constant.TableNameConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.util.Objects;

/**
 * 角色-应用-菜单-API-行规则
 *
 * @author chen
 */
@Entity
@Table(name = TableNameConstant.SYS_DPR_ROLE_API_RULE_DO, indexes = {
        @Index(name = "idx_dpr_row_role", columnList = "roleId"),
        @Index(name = "idx_dpr_row_app", columnList = "appCode"),
        @Index(name = "idx_dpr_row_menu", columnList = "menuCode"),
        @Index(name = "idx_dpr_row_api", columnList = "apiCode"),
})
@org.hibernate.annotations.Table(appliesTo = TableNameConstant.SYS_DPR_ROLE_API_RULE_DO, comment = "角色-应用-菜单-API-行规则")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = TableNameConstant.SYS_DPR_ROLE_API_RULE_DO, description = "角色-应用-菜单-API-行规则")
public class SysDprRoleApiRowRuleDO extends BaseModel {
    private static final long serialVersionUID = -794532836107589206L;

    @ApiModelProperty("角色id")
    @Comment("角色id")
    private Long roleId;

    @ApiModelProperty("应用编码")
    @Comment("应用编码")
    private String appCode;

    @ApiModelProperty("菜单编码-因有自定义菜单，采用编码")
    @Comment("菜单编码")
    private String menuCode;

    @Comment("Api Code")
    private String apiCode;

    @ApiModelProperty("行规则组id")
    @Comment("行规则组id")
    private Long dprRuleGroupId;

    @ApiModelProperty("行规则id")
    @Comment("行规则id")
    private Long dprRuleId;

    @ApiModelProperty("自定义值")
    @Comment("自定义值")
    @Column
    private String roleRuleValue;

    @ApiModelProperty("自定义值填写类型")
    @Comment("自定义值填写类型（组件，自填）")
    @Column()
    private String roleRuleValueType;

    @ApiModelProperty("规则排序")
    @Comment("规则排序")
    @Column()
    private Integer ruleOrder;


    @ApiModelProperty("规则关系（and-or）")
    @Comment("规则关系")
    @Column()
    private String dprRuleRelation;

    @ApiModelProperty("规则关系名称")
    @Comment("规则关系名称")
    @Column()
    private String dprRuleRelationName;

    @ApiModelProperty("规则名称")
    @Comment("规则名称")
    @Column()
    private String dprRuleName;

    @ApiModelProperty("规则描述")
    @Comment("规则描述")
    @Column()
    @Lob
    private String dprRuleDeclare;

    @ApiModelProperty("规则字段")
    @Comment("规则字段")
    @Column()
    private String dprRuleField;

    @ApiModelProperty("规则字段类型")
    @Comment("规则字段类型")
    @Column()
    private String dprRuleFieldType;

    @ApiModelProperty("规则条件类型名称")
    @Comment("规则字段类型名称")
    @Column()
    private String dprRuleFieldTypeName;

    @ApiModelProperty("规则字段描述")
    @Comment("规则字段描述")
    @Column()
    @Lob
    private String dprRuleFieldDeclare;

    @ApiModelProperty("规则条件类型")
    @Comment("规则条件类型")
    @Column()
    private String dprRuleCondition;
    @ApiModelProperty("规则条件类型名称")
    @Comment("规则条件类型名称")
    @Column()
    private String dprRuleConditionName;

    @ApiModelProperty("规则值类型")
    @Comment("规则值类型")
    @Column()
    private String dprRuleValueType;
    @ApiModelProperty("规则值类型名称")
    @Comment("规则值类型名称")
    @Column()
    private String dprRuleValueTypeName;

    @Comment("数据集类型")
    @Column
    private String dataSet;

    @ApiModelProperty("规则值")
    @Comment("规则值")
    @Column()
    private String dprRuleValue;

    @ApiModelProperty("规则值名称")
    @Comment("规则值名称")
    @Column
    private String dprRuleValueName;

    @ApiModelProperty("规则值说明")
    @Comment("规则值说明")
    @Column()
    @Lob
    private String dprRuleValueDeclare;

    @ApiModelProperty("系统上下文内置类型枚举")
    @Comment("系统上下文内置类型枚举")
    @Column()
    private String dprSysInternally;
    @ApiModelProperty("系统上下文内置类型名称")
    @Comment("系统上下文内置类型名称")
    @Column()
    private String dprSysInternallyName;

    @Column()
    @Comment(value = "是否是数据范围")
    private Boolean dataRange;

    @Comment("特用字段1")
    @Column
    private String bs1;

    @Comment("特用字段2")
    @Column
    private String bs2;

    @Comment("特用字段3")
    @Column
    private String bs3;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SysDprRoleApiRowRuleDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SysDprRoleApiRowRuleDO entity = (SysDprRoleApiRowRuleDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}