package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.*;

/**
 * 系统公告内容.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/22
 */
@Entity
@Table(name = "sys_notice_txt", indexes = {
        @Index(name = "idx_notice_txt_noticeid", columnList = "noticeId"),
})
@Comment("系统公告内容")
@DynamicInsert
@Getter
@Setter
public class SysNoticeTxtDO extends BaseModel {
    private static final long serialVersionUID = -7345249920633951344L;

    @Comment(value = "公告ID")
    @Column(nullable = false)
    private Long noticeId;

    @Comment(value = "公告内容")
    @Column()
    @Lob
    private String txt;
}
