package com.elitescloud.cloudt.system.service.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * OpenAPI标签.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/13
 */
@Entity
@Table(name = "sys_openapi_tag", indexes = {
        @Index(name = "idx_openapi_tag_info", columnList = "openApiInfoId"),
        @Index(name = "idx_openapi_tag_opera", columnList = "operationId"),
        @Index(name = "idx_openapi_tag_tag", columnList = "tag"),
})
@Comment("OpenAPI标签")
@DynamicInsert
@Getter
@Setter
public class SysOpenApiTagDO extends BaseModel {
    private static final long serialVersionUID = 530365880938352795L;

    @Comment(value = "openApi信息ID")
    @Column(nullable = false)
    private Long openApiInfoId;

    @Comment(value = "openApi操作ID")
    @Column()
    private Long operationId;

    @Comment(value = "tag内容")
    @Column()
    private String tag;

    @Comment(value = "序号", defaultValue = "0")
    @Column()
    private Integer sortNo;
}
